/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.collection.MotionStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.MotionStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.MotionStateType;
import rst.domotic.unit.UnitTemplateType;
import rst.timing.TimestampType;

public class MotionStateServiceRemote
extends AbstractServiceRemote<MotionStateProviderService, MotionStateType.MotionState>
implements MotionStateProviderServiceCollection {
    public MotionStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.MOTION_STATE_SERVICE, MotionStateType.MotionState.class);
    }

    public Collection<MotionStateProviderService> getMotionStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected MotionStateType.MotionState computeServiceState() throws CouldNotPerformException {
        return this.getMotionState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public MotionStateType.MotionState getMotionState() throws NotAvailableException {
        return (MotionStateType.MotionState)this.getServiceState();
    }

    public MotionStateType.MotionState getMotionState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        MotionStateType.MotionState.State motionValue = MotionStateType.MotionState.State.NO_MOTION;
        long lastMotion = 0L;
        long timestamp = 0L;
        for (MotionStateProviderService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) continue;
            MotionStateType.MotionState motionState = service.getMotionState();
            if (motionState.getValue() == MotionStateType.MotionState.State.MOTION) {
                motionValue = MotionStateType.MotionState.State.MOTION;
            }
            if (motionState.hasLastMotion() && motionState.getLastMotion().getTime() > lastMotion) {
                lastMotion = motionState.getLastMotion().getTime();
            }
            timestamp = Math.max(timestamp, motionState.getTimestamp().getTime());
        }
        return ((MotionStateType.MotionState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)MotionStateType.MotionState.newBuilder().setValue(motionValue).setLastMotion(TimestampType.Timestamp.newBuilder().setTime(lastMotion)), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

