/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.HandleStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.HandleStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.HandleStateType;
import rst.domotic.unit.UnitTemplateType;

public class HandleStateServiceRemote
extends AbstractServiceRemote<HandleStateProviderService, HandleStateType.HandleState>
implements HandleStateProviderServiceCollection {
    public HandleStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.HANDLE_STATE_SERVICE, HandleStateType.HandleState.class);
    }

    public Collection<HandleStateProviderService> getHandleStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected HandleStateType.HandleState computeServiceState() throws CouldNotPerformException {
        return this.getHandleState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public HandleStateType.HandleState getHandleState() throws NotAvailableException {
        return (HandleStateType.HandleState)this.getServiceState();
    }

    public HandleStateType.HandleState getHandleState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        int position = 0;
        Collection handleStateProviderServices = this.getServices(unitType);
        int amount = handleStateProviderServices.size();
        long timestamp = 0L;
        for (HandleStateProviderService service : handleStateProviderServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            position += service.getHandleState().getPosition();
            timestamp = Math.max(timestamp, service.getHandleState().getTimestamp().getTime());
        }
        return ((HandleStateType.HandleState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)HandleStateType.HandleState.newBuilder().setPosition(position /= amount), (Logger)this.logger)).build();
    }
}

