/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.IlluminanceStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.IlluminanceStateProviderService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.IlluminanceStateType;
import rst.domotic.unit.UnitTemplateType;

public class IlluminanceStateServiceRemote
extends AbstractServiceRemote<IlluminanceStateProviderService, IlluminanceStateType.IlluminanceState>
implements IlluminanceStateProviderServiceCollection {
    public IlluminanceStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.ILLUMINANCE_STATE_SERVICE, IlluminanceStateType.IlluminanceState.class);
    }

    public Collection<IlluminanceStateProviderService> getIlluminanceStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected IlluminanceStateType.IlluminanceState computeServiceState() throws CouldNotPerformException {
        return this.getIlluminanceState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public IlluminanceStateType.IlluminanceState getIlluminanceState() throws NotAvailableException {
        return (IlluminanceStateType.IlluminanceState)this.getServiceState();
    }

    public IlluminanceStateType.IlluminanceState getIlluminanceState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        double averageIlluminance = 0.0;
        long timestamp = 0L;
        Collection illuminanceStateProviderServices = this.getServices(unitType);
        int amount = illuminanceStateProviderServices.size();
        for (IlluminanceStateProviderService service : illuminanceStateProviderServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            averageIlluminance += (double)Math.max(timestamp, service.getIlluminanceState().getTimestamp().getTime());
        }
        return ((IlluminanceStateType.IlluminanceState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)IlluminanceStateType.IlluminanceState.newBuilder().setIlluminance(averageIlluminance /= (double)amount).setIlluminanceDataUnit(IlluminanceStateType.IlluminanceState.DataUnit.LUX), (Logger)this.logger)).build();
    }
}

