/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.PowerConsumptionStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.PowerConsumptionStateProviderService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PowerConsumptionStateType;
import rst.domotic.unit.UnitTemplateType;

public class PowerConsumptionStateServiceRemote
extends AbstractServiceRemote<PowerConsumptionStateProviderService, PowerConsumptionStateType.PowerConsumptionState>
implements PowerConsumptionStateProviderServiceCollection {
    public PowerConsumptionStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_CONSUMPTION_STATE_SERVICE, PowerConsumptionStateType.PowerConsumptionState.class);
    }

    public Collection<PowerConsumptionStateProviderService> getPowerConsumptionStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected PowerConsumptionStateType.PowerConsumptionState computeServiceState() throws CouldNotPerformException {
        return this.getPowerConsumptionState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public PowerConsumptionStateType.PowerConsumptionState getPowerConsumptionState() throws NotAvailableException {
        return (PowerConsumptionStateType.PowerConsumptionState)this.getServiceState();
    }

    public PowerConsumptionStateType.PowerConsumptionState getPowerConsumptionState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        double consumptionSum = 0.0;
        double averageCurrent = 0.0;
        double averageVoltage = 0.0;
        long timestamp = 0L;
        Collection powerConsumptionStateProviderServices = this.getServices(unitType);
        int amount = powerConsumptionStateProviderServices.size();
        for (PowerConsumptionStateProviderService service : powerConsumptionStateProviderServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            consumptionSum += service.getPowerConsumptionState().getConsumption();
            averageCurrent += service.getPowerConsumptionState().getCurrent();
            averageVoltage += service.getPowerConsumptionState().getVoltage();
            timestamp = Math.max(timestamp, service.getPowerConsumptionState().getTimestamp().getTime());
        }
        return ((PowerConsumptionStateType.PowerConsumptionState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)PowerConsumptionStateType.PowerConsumptionState.newBuilder().setConsumption(consumptionSum).setCurrent(averageCurrent /= (double)amount).setVoltage(averageVoltage /= (double)amount), (Logger)this.logger)).build();
    }
}

