/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.TamperStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.TamperStateProviderService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.TamperStateType;
import rst.domotic.unit.UnitTemplateType;
import rst.timing.TimestampType;

public class TamperStateServiceRemote
extends AbstractServiceRemote<TamperStateProviderService, TamperStateType.TamperState>
implements TamperStateProviderServiceCollection {
    public TamperStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.TAMPER_STATE_SERVICE, TamperStateType.TamperState.class);
    }

    public Collection<TamperStateProviderService> getTamperStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected TamperStateType.TamperState computeServiceState() throws CouldNotPerformException {
        return this.getTamperState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public TamperStateType.TamperState getTamperState() throws NotAvailableException {
        return (TamperStateType.TamperState)this.getServiceState();
    }

    public TamperStateType.TamperState getTamperState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        TamperStateType.TamperState.State tamperValue = TamperStateType.TamperState.State.NO_TAMPER;
        long lastDetection = 0L;
        long timestamp = 0L;
        for (TamperStateProviderService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) continue;
            TamperStateType.TamperState tamperState = service.getTamperState();
            if (tamperState.getValue() == TamperStateType.TamperState.State.TAMPER) {
                tamperValue = TamperStateType.TamperState.State.TAMPER;
            }
            if (tamperState.getLastDetection().getTime() > lastDetection) {
                lastDetection = tamperState.getLastDetection().getTime();
            }
            timestamp = Math.max(timestamp, tamperState.getTimestamp().getTime());
        }
        return ((TamperStateType.TamperState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)TamperStateType.TamperState.newBuilder().setValue(tamperValue).setLastDetection(TimestampType.Timestamp.newBuilder().setTime(lastDetection)), (Logger)this.logger)).build();
    }
}

