/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.SmokeStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.SmokeStateProviderService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.SmokeStateType;
import rst.domotic.unit.UnitTemplateType;

public class SmokeStateServiceRemote
extends AbstractServiceRemote<SmokeStateProviderService, SmokeStateType.SmokeState>
implements SmokeStateProviderServiceCollection {
    public SmokeStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.SMOKE_STATE_SERVICE, SmokeStateType.SmokeState.class);
    }

    public Collection<SmokeStateProviderService> getSmokeStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected SmokeStateType.SmokeState computeServiceState() throws CouldNotPerformException {
        return this.getSmokeState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public SmokeStateType.SmokeState getSmokeState() throws NotAvailableException {
        return (SmokeStateType.SmokeState)this.getServiceState();
    }

    public SmokeStateType.SmokeState getSmokeState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        boolean someSmoke = false;
        SmokeStateType.SmokeState.State smokeValue = SmokeStateType.SmokeState.State.NO_SMOKE;
        Collection<SmokeStateProviderService> smokeStateProviderServices = this.getSmokeStateProviderServices();
        int amount = smokeStateProviderServices.size();
        double averageSmokeLevel = 0.0;
        long timestamp = 0L;
        for (SmokeStateProviderService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            SmokeStateType.SmokeState smokeState = service.getSmokeState();
            if (smokeState.getValue() == SmokeStateType.SmokeState.State.SMOKE) {
                smokeValue = SmokeStateType.SmokeState.State.SMOKE;
                break;
            }
            if (smokeState.getValue() == SmokeStateType.SmokeState.State.SOME_SMOKE) {
                someSmoke = true;
            }
            averageSmokeLevel += smokeState.getSmokeLevel();
            timestamp = Math.max(timestamp, smokeState.getTimestamp().getTime());
        }
        if (someSmoke) {
            smokeValue = SmokeStateType.SmokeState.State.SOME_SMOKE;
        }
        return ((SmokeStateType.SmokeState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)SmokeStateType.SmokeState.newBuilder().setValue(smokeValue).setSmokeLevel(averageSmokeLevel /= (double)amount), (Logger)this.logger)).build();
    }
}

