/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.DimmableLight;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.DimmableLightDataType;

public class DimmableLightRemote
extends AbstractUnitRemote<DimmableLightDataType.DimmableLightData>
implements DimmableLight {
    public DimmableLightRemote() {
        super(DimmableLightDataType.DimmableLightData.class);
    }

    public void notifyDataUpdate(DimmableLightDataType.DimmableLightData data) {
    }

    public Future<Void> setPowerState(PowerStateType.PowerState.State value) throws CouldNotPerformException {
        return this.setPowerState(PowerStateType.PowerState.newBuilder().setValue(value).build());
    }

    public Future<Void> setPowerState(PowerStateType.PowerState value) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)value, (RSBRemote)this, Void.class);
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((DimmableLightDataType.DimmableLightData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState brightness) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)brightness, (RSBRemote)this, Void.class);
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        try {
            return ((DimmableLightDataType.DimmableLightData)this.getData()).getBrightnessState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("BrightnessState", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)DimmableLightDataType.DimmableLightData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
    }
}

