/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.Collection;
import org.openbase.bco.dal.lib.layer.service.collection.PresenceStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.PresenceStateProviderService;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitTemplateType;

public class PresenceStateServiceRemote
extends AbstractServiceRemote<PresenceStateProviderService, PresenceStateType.PresenceState>
implements PresenceStateProviderServiceCollection {
    public PresenceStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE, PresenceStateType.PresenceState.class);
    }

    @Override
    protected PresenceStateType.PresenceState computeServiceState() throws CouldNotPerformException {
        return this.getPresenceState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public PresenceStateType.PresenceState getPresenceState() throws NotAvailableException {
        return (PresenceStateType.PresenceState)this.getServiceState();
    }

    public PresenceStateType.PresenceState getPresenceState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        PresenceStateType.PresenceState.Builder builder = PresenceStateType.PresenceState.newBuilder().setValue(PresenceStateType.PresenceState.State.ABSENT);
        builder.getLastPresenceBuilder().setTime(0L);
        for (PresenceStateProviderService provider : this.getServices(unitType)) {
            if (!((UnitRemote)provider).isDataAvailable() || provider.getPresenceState().getValue() != PresenceStateType.PresenceState.State.PRESENT) continue;
            builder.setValue(PresenceStateType.PresenceState.State.PRESENT).build();
            builder.getLastPresenceBuilder().setTime(Math.max(builder.getLastPresence().getTime(), provider.getPresenceState().getLastPresence().getTime()));
        }
        return builder.build();
    }

    public Collection<PresenceStateProviderService> getPresenceStateProviderServices() throws CouldNotPerformException {
        return this.getServices();
    }
}

