/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.service.ServiceRemote;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.ShutdownException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.ActionReferenceType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public abstract class AbstractServiceRemote<S extends Service, ST extends GeneratedMessage>
implements ServiceRemote<S, ST> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean active;
    private final ServiceTemplateType.ServiceTemplate.ServiceType serviceType;
    private final Class<ST> serviceDataClass;
    private final Map<String, UnitRemote> unitRemoteMap;
    private final Map<UnitTemplateType.UnitTemplate.UnitType, List<S>> unitRemoteTypeMap;
    private final Map<String, S> serviceMap;
    private final Observer dataObserver;
    protected final ObservableImpl<ST> serviceStateObservable = new ObservableImpl();
    private final SyncObject syncObject = new SyncObject("ServiceStateComputationLock");
    private final SyncObject maintainerLock = new SyncObject("MaintainerLock");
    protected Object maintainer;

    public AbstractServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Class<ST> serviceDataClass) {
        this.serviceType = serviceType;
        this.serviceDataClass = serviceDataClass;
        this.unitRemoteMap = new HashMap<String, UnitRemote>();
        this.unitRemoteTypeMap = new HashMap<UnitTemplateType.UnitTemplate.UnitType, List<S>>();
        this.serviceMap = new HashMap<String, S>();
        this.dataObserver = (source, data) -> this.updateServiceState();
        this.serviceStateObservable.setExecutorService((ExecutorService)GlobalCachedExecutorService.getInstance().getExecutorService());
    }

    protected abstract ST computeServiceState() throws CouldNotPerformException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceState() throws CouldNotPerformException {
        ST serviceState;
        SyncObject syncObject = this.syncObject;
        synchronized (syncObject) {
            serviceState = this.computeServiceState();
        }
        this.serviceStateObservable.notifyObservers(serviceState);
        assert (this.serviceStateObservable.isValueAvailable());
    }

    @Deprecated
    public ST getServiceState() throws NotAvailableException {
        if (!this.serviceStateObservable.isValueAvailable()) {
            throw new NotAvailableException("ServiceState");
        }
        return (ST)((GeneratedMessage)this.serviceStateObservable.getValue());
    }

    public ST getData() throws NotAvailableException {
        if (!this.serviceStateObservable.isValueAvailable()) {
            throw new NotAvailableException("Data");
        }
        return (ST)((GeneratedMessage)this.serviceStateObservable.getValue());
    }

    public void addDataObserver(Observer<ST> observer) {
        this.serviceStateObservable.addObserver(observer);
    }

    public void removeDataObserver(Observer<ST> observer) {
        this.serviceStateObservable.removeObserver(observer);
    }

    public void addServiceStateObserver(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Observer observer) {
        try {
            if (serviceType != this.getServiceType()) {
                throw new VerificationFailedException("ServiceType[" + serviceType.name() + "] is not compatible with " + this);
            }
            this.addDataObserver(observer);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not add service state observer!", (Throwable)ex), (Logger)this.logger);
        }
    }

    public void removeServiceStateObserver(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Observer observer) {
        try {
            if (serviceType != this.getServiceType()) {
                throw new VerificationFailedException("ServiceType[" + serviceType.name() + "] is not compatible with " + this);
            }
            this.addDataObserver(observer);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not remove service state observer!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
    }

    public Class<ST> getDataClass() {
        return this.serviceDataClass;
    }

    public CompletableFuture<ST> requestData(boolean failOnError) throws CouldNotPerformException {
        CompletableFuture requestDataFuture = new CompletableFuture();
        GlobalCachedExecutorService.submit(() -> {
            try {
                ArrayList<CompletableFuture> taskList = new ArrayList<CompletableFuture>();
                MultiException.ExceptionStack exceptionStack = null;
                for (Remote remote : this.getInternalUnits()) {
                    try {
                        taskList.add(remote.requestData());
                    }
                    catch (CouldNotPerformException couldNotPerformException) {
                        MultiException.push((Object)remote, (Exception)((Object)couldNotPerformException), exceptionStack);
                    }
                }
                boolean noResponse = true;
                for (Future future : taskList) {
                    try {
                        future.get();
                        noResponse = false;
                    }
                    catch (ExecutionException ex) {
                        MultiException.push((Object)future, (Exception)ex, exceptionStack);
                    }
                }
                try {
                    MultiException.checkAndThrow((String)"Could not request status of all internal remotes!", exceptionStack);
                }
                catch (MultiException multiException) {
                    if (failOnError || noResponse) {
                        throw multiException;
                    }
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not request data of all internal unit remotes!", (Throwable)multiException), (Logger)this.logger, (LogLevel)LogLevel.WARN);
                }
                requestDataFuture.complete(this.getData());
            }
            catch (InterruptedException | CouldNotPerformException ex) {
                requestDataFuture.completeExceptionally(ex);
            }
        });
        return requestDataFuture;
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            this.verifyMaintainability();
            if (!AbstractServiceRemote.verifyServiceCompatibility(config, this.serviceType)) {
                throw new NotSupportedException((Object)("UnitTemplate[" + this.serviceType.name() + "]"), (Object)config.getLabel());
            }
            UnitRemote<?> remote = Units.getUnit(config, false);
            if (!this.unitRemoteTypeMap.containsKey(remote.getType())) {
                this.unitRemoteTypeMap.put(remote.getType(), new ArrayList());
                for (UnitTemplateType.UnitTemplate.UnitType superType : Registries.getUnitRegistry().getSuperUnitTypes(remote.getType())) {
                    if (this.unitRemoteTypeMap.containsKey(superType)) continue;
                    this.unitRemoteTypeMap.put(superType, new ArrayList());
                }
            }
            try {
                this.serviceMap.put(config.getId(), remote);
                this.unitRemoteTypeMap.get(remote.getType()).add(remote);
                for (UnitTemplateType.UnitTemplate.UnitType superType : Registries.getUnitRegistry().getSuperUnitTypes(remote.getType())) {
                    this.unitRemoteTypeMap.get(superType).add(remote);
                }
            }
            catch (ClassCastException ex) {
                throw new NotSupportedException((Object)("ServiceInterface[" + this.serviceType.name() + "]"), remote, "Remote does not implement the service interface!", (Throwable)ex);
            }
            this.unitRemoteMap.put(config.getId(), remote);
            if (this.active) {
                if (!remote.isEnabled()) {
                    this.logger.warn("Using a disabled " + remote + " in " + this + " is not recommended and should be avoided!");
                }
                remote.addDataObserver(this.dataObserver);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(Collection<UnitConfigType.UnitConfig> configs) throws InitializationException, InterruptedException {
        try {
            this.verifyMaintainability();
            MultiException.ExceptionStack exceptionStack = null;
            for (UnitConfigType.UnitConfig config : configs) {
                try {
                    this.init(config);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)"Could not activate all service units!", exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.verifyMaintainability();
        this.active = true;
        this.unitRemoteMap.values().stream().map(remote -> {
            if (!remote.isEnabled()) {
                this.logger.warn("Using a disabled " + remote + " in " + this + " is not recommended and should be avoided!");
            }
            return remote;
        }).forEach(remote -> remote.addDataObserver(this.dataObserver));
        this.updateServiceState();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.verifyMaintainability();
        this.active = false;
        this.unitRemoteMap.values().stream().forEach(remote -> remote.removeDataObserver(this.dataObserver));
    }

    public void shutdown() {
        try {
            this.verifyMaintainability();
            this.deactivate();
        }
        catch (InterruptedException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new ShutdownException((Object)this, ex), (Logger)this.logger);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void removeUnit(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException, InterruptedException {
        this.unitRemoteMap.get(unitConfig.getId()).removeDataObserver(this.dataObserver);
        this.unitRemoteMap.remove(unitConfig.getId());
    }

    public Collection<UnitRemote> getInternalUnits() {
        return Collections.unmodifiableCollection(this.unitRemoteMap.values());
    }

    public boolean hasInternalRemotes() {
        return !this.unitRemoteMap.isEmpty();
    }

    public Collection<S> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    public Collection<S> getServices(UnitTemplateType.UnitTemplate.UnitType unitType) {
        if (unitType == UnitTemplateType.UnitTemplate.UnitType.UNKNOWN) {
            return Collections.unmodifiableCollection(this.serviceMap.values());
        }
        if (!this.unitRemoteTypeMap.containsKey(unitType)) {
            return new ArrayList();
        }
        return Collections.unmodifiableCollection((Collection)this.unitRemoteTypeMap.get(unitType));
    }

    public ServiceTemplateType.ServiceTemplate.ServiceType getServiceType() {
        return this.serviceType;
    }

    public Future<ActionFutureType.ActionFuture> applyAction(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException, InterruptedException {
        try {
            if (!actionDescription.getServiceStateDescription().getServiceType().equals((Object)this.getServiceType())) {
                throw new VerificationFailedException("Service type is not compatible to given action config!");
            }
            ArrayList<Future> actionFutureList = new ArrayList<Future>();
            for (UnitRemote unitRemote : this.getInternalUnits()) {
                if (actionDescription.getServiceStateDescription().getUnitType() != UnitTemplateType.UnitTemplate.UnitType.UNKNOWN && actionDescription.getServiceStateDescription().getUnitType() != unitRemote.getType() && !UnitConfigProcessor.isBaseUnit((UnitTemplateType.UnitTemplate.UnitType)unitRemote.getType())) continue;
                ActionDescriptionType.ActionDescription.Builder unitActionDescription = ActionDescriptionType.ActionDescription.newBuilder((ActionDescriptionType.ActionDescription)actionDescription);
                ActionReferenceType.ActionReference.Builder actionReference = ActionReferenceType.ActionReference.newBuilder();
                actionReference.setActionId(actionDescription.getId());
                actionReference.setAuthority(actionDescription.getActionAuthority());
                actionReference.setServiceStateDescription(actionDescription.getServiceStateDescription());
                unitActionDescription.addActionChain(actionReference);
                ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = unitActionDescription.getServiceStateDescriptionBuilder();
                serviceStateDescription.setUnitId((String)unitRemote.getId());
                actionFutureList.add(unitRemote.applyAction(unitActionDescription.build()));
            }
            ActionFutureType.ActionFuture actionFuture = ActionFutureType.ActionFuture.getDefaultInstance();
            return GlobalCachedExecutorService.allOf((Object)actionFuture, actionFutureList);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not apply action!", (Throwable)ex);
        }
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        if (this.unitRemoteMap.isEmpty()) {
            return;
        }
        for (UnitRemote remote : this.unitRemoteMap.values()) {
            remote.waitForData();
        }
        this.serviceStateObservable.waitForValue();
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        if (this.unitRemoteMap.isEmpty()) {
            return;
        }
        for (UnitRemote remote : this.unitRemoteMap.values()) {
            remote.waitForData(timeout, timeUnit);
        }
        this.serviceStateObservable.waitForValue(timeout, timeUnit);
    }

    public boolean isConnected() {
        return this.getInternalUnits().stream().noneMatch(unitRemote -> !unitRemote.isConnected());
    }

    public boolean isDataAvailable() {
        if (!this.hasInternalRemotes()) {
            return false;
        }
        return this.serviceStateObservable.isValueAvailable();
    }

    public static boolean verifyServiceCompatibility(UnitConfigType.UnitConfig unitConfig, ServiceTemplateType.ServiceTemplate.ServiceType serviceType) {
        return unitConfig.getServiceConfigList().stream().anyMatch(serviceConfig -> serviceConfig.getServiceDescription().getType() == serviceType);
    }

    public void verifyMaintainability() throws VerificationFailedException {
        if (this.isLocked()) {
            throw new VerificationFailedException("Manipulation of " + this + "is currently not valid because the maintains is protected by another instance! Did you try to modify an instance which is locked by a managed instance pool?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            return this.maintainer != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object maintainer) throws CouldNotPerformException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            if (this.maintainer != null) {
                throw new CouldNotPerformException("Could not lock remote for because remote is already locked by another instance!");
            }
            this.maintainer = maintainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object maintainer) throws CouldNotPerformException {
        SyncObject syncObject = this.maintainerLock;
        synchronized (syncObject) {
            if (this.maintainer != null && this.maintainer != maintainer) {
                throw new CouldNotPerformException("Could not unlock remote for because remote is locked by another instance!");
            }
            this.maintainer = null;
        }
    }

    @Deprecated
    public void setInfrastructureFilter(boolean enabled) {
    }

    public String toString() {
        if (this.serviceType == null) {
            return this.getClass().getSimpleName() + "[serviceType: ? ]";
        }
        return this.getClass().getSimpleName() + "[serviceType:" + this.serviceType.name() + "]";
    }
}

