/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.lib.layer.unit.Unit;
import org.openbase.bco.dal.lib.layer.unit.UnitProcessor;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactoryImpl;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Snapshotable;
import org.openbase.jul.iface.provider.LabelProvider;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.SnapshotType;
import rst.domotic.service.ServiceDescriptionType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public abstract class ServiceRemoteManager
implements Activatable,
Snapshotable<SnapshotType.Snapshot> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRemoteManager.class);
    private boolean active;
    private final SyncObject serviceRemoteMapLock = new SyncObject("ServiceRemoteMapLock");
    private final ServiceRemoteFactory serviceRemoteFactory;
    private final Map<ServiceTemplateType.ServiceTemplate.ServiceType, AbstractServiceRemote> serviceRemoteMap;
    private final Observer serviceDataObserver;
    private final LabelProvider responsibleInstance;

    public ServiceRemoteManager() {
        this(null);
    }

    public ServiceRemoteManager(LabelProvider responsibleInstance) {
        this.responsibleInstance = responsibleInstance;
        this.serviceRemoteMap = new HashMap<ServiceTemplateType.ServiceTemplate.ServiceType, AbstractServiceRemote>();
        this.serviceRemoteFactory = ServiceRemoteFactoryImpl.getInstance();
        this.serviceDataObserver = (source, data) -> this.notifyServiceUpdate(source, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyConfigUpdate(List<String> unitIDList) throws CouldNotPerformException, InterruptedException {
        Registries.getUnitRegistry().waitForData();
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            for (AbstractServiceRemote serviceRemote : this.serviceRemoteMap.values()) {
                serviceRemote.removeDataObserver(this.serviceDataObserver);
                serviceRemote.shutdown();
            }
            this.serviceRemoteMap.clear();
            HashMap serviceMap = new HashMap();
            for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : ServiceTemplateType.ServiceTemplate.ServiceType.values()) {
                serviceMap.put(serviceType, new HashSet());
            }
            for (String unitId : unitIDList) {
                UnitConfigType.UnitConfig unitConfig = Registries.getUnitRegistry().getUnitConfigById(unitId);
                try {
                    if (!UnitConfigProcessor.isDalUnit((UnitConfigType.UnitConfig)unitConfig)) {
                        continue;
                    }
                }
                catch (VerificationFailedException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("UnitConfig[" + unitConfig + "] could not be verified as a dal unit!", (Throwable)ex), (Logger)LOGGER);
                }
                unitConfig.getServiceConfigList().stream().forEach(serviceConfig -> ((Set)serviceMap.get(serviceConfig.getServiceDescription().getType())).add(unitConfig));
            }
            for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : this.getManagedServiceTypes()) {
                AbstractServiceRemote serviceRemote = this.serviceRemoteFactory.newInitializedInstance(serviceType, (Collection)serviceMap.get(serviceType));
                this.serviceRemoteMap.put(serviceType, serviceRemote);
                if (!this.isActive()) continue;
                serviceRemote.addDataObserver(this.serviceDataObserver);
                serviceRemote.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            this.active = true;
            for (AbstractServiceRemote serviceRemote : this.serviceRemoteMap.values()) {
                serviceRemote.addDataObserver(this.serviceDataObserver);
                serviceRemote.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            this.active = false;
            for (AbstractServiceRemote serviceRemote : this.serviceRemoteMap.values()) {
                serviceRemote.removeDataObserver(this.serviceDataObserver);
                serviceRemote.deactivate();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractServiceRemote> getServiceRemoteList() {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            return new ArrayList<AbstractServiceRemote>(this.serviceRemoteMap.values());
        }
    }

    public boolean isServiceAvailable(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) {
        try {
            return this.getServiceRemote(serviceType).hasInternalRemotes();
        }
        catch (NotAvailableException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractServiceRemote getServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws NotAvailableException {
        SyncObject syncObject = this.serviceRemoteMapLock;
        synchronized (syncObject) {
            AbstractServiceRemote serviceRemote = this.serviceRemoteMap.get(serviceType);
            if (serviceRemote == null) {
                String responsible;
                try {
                    responsible = this.responsibleInstance != null ? this.responsibleInstance.getLabel() : "the underlying instance";
                }
                catch (NotAvailableException ex) {
                    responsible = "the underlying instance";
                }
                throw new NotAvailableException("ServiceRemote", serviceType.name(), (Throwable)new NotSupportedException((Object)("ServiceType[" + serviceType + "]"), (Object)responsible));
            }
            return serviceRemote;
        }
    }

    public <B> B updateBuilderWithAvailableServiceStates(B builder, Class dataClass, Set<ServiceTemplateType.ServiceTemplate.ServiceType> supportedServiceTypeSet) throws InterruptedException {
        try {
            for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : supportedServiceTypeSet) {
                Object serviceState;
                try {
                    AbstractServiceRemote serviceRemote = this.getServiceRemote(serviceType);
                    if (serviceRemote == null || !serviceRemote.isDataAvailable()) continue;
                    serviceState = Services.invokeProviderServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)serviceType, (Object)serviceRemote, (Object[])new Object[0]);
                }
                catch (NotAvailableException ex) {
                    ExceptionPrinter.printHistory((String)("No service data for type[" + serviceType + "] on location available!"), (Throwable)ex, (Logger)LOGGER);
                    continue;
                }
                catch (IllegalArgumentException | NotSupportedException ex) {
                    ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException((Object)this, ex), (Logger)LOGGER);
                    continue;
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)("Could not update ServiceState[" + serviceType.name() + "] for " + this), (Throwable)ex, (Logger)LOGGER);
                    continue;
                }
                try {
                    Services.invokeOperationServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)serviceType, builder, (Object[])new Object[]{serviceState});
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new NotSupportedException((Object)("Field[" + serviceType.name().toLowerCase().replace("_service", "") + "] is missing in protobuf type " + dataClass + "!"), (Object)this, (Throwable)ex), (Logger)LOGGER);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
            new CouldNotPerformException("Could not update current status!", (Throwable)ex);
        }
        return builder;
    }

    public Future<SnapshotType.Snapshot> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return this.recordSnapshot(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public Future<SnapshotType.Snapshot> recordSnapshot(UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException, InterruptedException {
        try {
            SnapshotType.Snapshot.Builder snapshotBuilder = SnapshotType.Snapshot.newBuilder();
            HashSet<UnitRemote> unitRemoteSet = new HashSet<UnitRemote>();
            if (unitType == UnitTemplateType.UnitTemplate.UnitType.UNKNOWN) {
                this.getServiceRemoteList().stream().forEach(serviceRemote -> unitRemoteSet.addAll(serviceRemote.getInternalUnits()));
            } else {
                ServiceTemplateType.ServiceTemplate.ServiceType serviceType;
                try {
                    serviceType = ((ServiceDescriptionType.ServiceDescription)Registries.getUnitRegistry().getUnitTemplateByType(unitType).getServiceDescriptionList().get(0)).getType();
                }
                catch (IndexOutOfBoundsException ex) {
                    return CompletableFuture.completedFuture(snapshotBuilder.build());
                }
                for (AbstractServiceRemote abstractServiceRemote : this.getServiceRemoteList()) {
                    if (serviceType != abstractServiceRemote.getServiceType()) continue;
                    Collection<UnitRemote> internalUnits = abstractServiceRemote.getInternalUnits();
                    for (UnitRemote unitRemote : internalUnits) {
                        if (unitRemote.getType() != unitType) continue;
                        unitRemoteSet.add(unitRemote);
                    }
                }
            }
            HashMap<UnitRemote, Future> snapshotFutureMap = new HashMap<UnitRemote, Future>();
            for (UnitRemote unitRemote : unitRemoteSet) {
                try {
                    if (!UnitProcessor.isDalUnit((Unit)unitRemote)) continue;
                    if (!unitRemote.isConnected()) {
                        throw new NotAvailableException("Unit[" + unitRemote.getLabel() + "] is currently not reachable!");
                    }
                    snapshotFutureMap.put(unitRemote, unitRemote.recordSnapshot());
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not record snapshot of " + unitRemote.getLabel(), (Throwable)ex), (Logger)LOGGER);
                }
            }
            for (Map.Entry entry : snapshotFutureMap.entrySet()) {
                try {
                    snapshotBuilder.addAllServiceStateDescription((Iterable)((SnapshotType.Snapshot)((Future)entry.getValue()).get(5L, TimeUnit.SECONDS)).getServiceStateDescriptionList());
                }
                catch (ExecutionException | TimeoutException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not record snapshot of " + ((UnitRemote)entry.getKey()).getLabel(), (Throwable)ex), (Logger)LOGGER);
                }
            }
            return CompletableFuture.completedFuture(snapshotBuilder.build());
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not record snapshot!", (Throwable)ex);
        }
    }

    public Future<Void> restoreSnapshot(SnapshotType.Snapshot snapshot) throws CouldNotPerformException, InterruptedException {
        try {
            HashMap<Object, UnitRemote> unitRemoteMap = new HashMap<Object, UnitRemote>();
            for (AbstractServiceRemote serviceRemote : this.getServiceRemoteList()) {
                for (UnitRemote unitRemote : serviceRemote.getInternalUnits()) {
                    unitRemoteMap.put(unitRemote.getId(), unitRemote);
                }
            }
            ArrayList<Future> futureCollection = new ArrayList<Future>();
            for (ServiceStateDescriptionType.ServiceStateDescription serviceStateDescription : snapshot.getServiceStateDescriptionList()) {
                ActionDescriptionType.ActionDescription actionDescription = ActionDescriptionType.ActionDescription.newBuilder().setServiceStateDescription(serviceStateDescription).build();
                futureCollection.add(((UnitRemote)unitRemoteMap.get(serviceStateDescription.getUnitId())).applyAction(actionDescription));
            }
            return GlobalCachedExecutorService.allOf(futureCollection);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not record snapshot!", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> applyAction(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException, InterruptedException {
        return this.getServiceRemote(actionDescription.getServiceStateDescription().getServiceType()).applyAction(actionDescription);
    }

    protected abstract Set<ServiceTemplateType.ServiceTemplate.ServiceType> getManagedServiceTypes() throws NotAvailableException, InterruptedException;

    protected abstract void notifyServiceUpdate(Observable var1, Object var2) throws NotAvailableException, InterruptedException;
}

