/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service.consumer;

import org.openbase.bco.dal.lib.layer.service.ServiceRemote;
import org.openbase.bco.dal.lib.layer.unit.UnitController;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactoryImpl;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotInitializedException;
import org.openbase.jul.iface.Manageable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.service.ServiceConfigType;

public class Consumer
implements Manageable<ServiceConfigType.ServiceConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Consumer.class);
    private boolean active = false;
    private ServiceRemote boundedProviderService;
    private final UnitController boundedUnitController;
    private final Observer serviceStateObserver;

    public Consumer(final UnitController boundedUnitController) {
        this.boundedUnitController = boundedUnitController;
        this.serviceStateObserver = new Observer(){

            public void update(Observable source, Object data) throws Exception {
                if (Consumer.this.boundedProviderService != null) {
                    boundedUnitController.applyDataUpdate(Consumer.this.boundedProviderService.getServiceType(), data);
                }
            }
        };
    }

    public synchronized void init(ServiceConfigType.ServiceConfig providerServiceConfig) throws InitializationException, InterruptedException {
        try {
            if (this.boundedProviderService != null) {
                this.boundedProviderService.shutdown();
            }
            this.boundedProviderService = ServiceRemoteFactoryImpl.getInstance().newInitializedInstanceById(providerServiceConfig.getServiceDescription().getType(), providerServiceConfig.getUnitId());
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        try {
            this.validateInitialization();
            this.active = true;
            this.boundedUnitController.addServiceStateObserver(this.boundedProviderService.getServiceType(), this.serviceStateObserver);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate " + this, (Throwable)ex);
        }
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.boundedUnitController.removeServiceStateObserver(this.boundedProviderService.getServiceType(), this.serviceStateObserver);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void validateInitialization() throws NotInitializedException {
        if (this.boundedProviderService == null) {
            throw new NotInitializedException((Object)this);
        }
    }
}

