/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.RollerShutter;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.state.BlindStateType;
import rst.domotic.unit.dal.RollerShutterDataType;

public class RollerShutterRemote
extends AbstractUnitRemote<RollerShutterDataType.RollerShutterData>
implements RollerShutter {
    public RollerShutterRemote() {
        super(RollerShutterDataType.RollerShutterData.class);
    }

    public Future<ActionFutureType.ActionFuture> setBlindState(BlindStateType.BlindState.MovementState movementState) throws CouldNotPerformException {
        return this.setBlindState(BlindStateType.BlindState.newBuilder().setMovementState(movementState).build());
    }

    public Future<ActionFutureType.ActionFuture> setBlindState(BlindStateType.BlindState blindState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, blindState).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting powerState.", (Throwable)ex);
        }
    }

    public BlindStateType.BlindState getBlindState() throws NotAvailableException {
        try {
            return ((RollerShutterDataType.RollerShutterData)this.getData()).getBlindState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("BlindState", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)RollerShutterDataType.RollerShutterData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BlindStateType.BlindState.getDefaultInstance()));
    }
}

