/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.BatteryRemote;
import org.openbase.bco.dal.remote.unit.ButtonRemote;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.bco.dal.remote.unit.DimmableLightRemote;
import org.openbase.bco.dal.remote.unit.DimmerRemote;
import org.openbase.bco.dal.remote.unit.HandleRemote;
import org.openbase.bco.dal.remote.unit.LightRemote;
import org.openbase.bco.dal.remote.unit.LightSensorRemote;
import org.openbase.bco.dal.remote.unit.MonitorRemote;
import org.openbase.bco.dal.remote.unit.MotionDetectorRemote;
import org.openbase.bco.dal.remote.unit.PowerConsumptionSensorRemote;
import org.openbase.bco.dal.remote.unit.PowerSwitchRemote;
import org.openbase.bco.dal.remote.unit.ReedContactRemote;
import org.openbase.bco.dal.remote.unit.RollerShutterRemote;
import org.openbase.bco.dal.remote.unit.SmokeDetectorRemote;
import org.openbase.bco.dal.remote.unit.TamperDetectorRemote;
import org.openbase.bco.dal.remote.unit.TemperatureControllerRemote;
import org.openbase.bco.dal.remote.unit.TemperatureSensorRemote;
import org.openbase.bco.dal.remote.unit.UnitGroupRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.dal.remote.unit.agent.AgentRemote;
import org.openbase.bco.dal.remote.unit.app.AppRemote;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.dal.remote.unit.device.DeviceRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.dal.remote.unit.scene.SceneRemote;
import org.openbase.bco.dal.remote.unit.user.UserRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.registry.RemoteControllerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rsb.Scope;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public class Units {
    private static final Logger LOGGER = LoggerFactory.getLogger(Units.class);
    public static final Class<? extends AgentRemote> BASE_UNIT_AGENT = AgentRemote.class;
    public static final Class<? extends AppRemote> BASE_UNIT_APP = AppRemote.class;
    public static final Class<? extends SceneRemote> BASE_UNIT_SCENE = SceneRemote.class;
    public static final Class<? extends UnitGroupRemote> BASE_UNIT_UNITGROUP = UnitGroupRemote.class;
    public static final Class<? extends UserRemote> BASE_UNIT_USER = UserRemote.class;
    public static final Class<? extends DeviceRemote> BASE_UNIT_DEVICE = DeviceRemote.class;
    public static final Class<? extends LocationRemote> BASE_UNIT_LOCATION = LocationRemote.class;
    public static final Class<? extends ConnectionRemote> BASE_UNIT_CONNECTION = ConnectionRemote.class;
    public static final Class<? extends ConnectionRemote> BASE_UNIT_CONNECTION_DOOR = ConnectionRemote.class;
    public static final Class<? extends ConnectionRemote> BASE_UNIT_CONNECTION_WINDOW = ConnectionRemote.class;
    public static final Class<? extends ConnectionRemote> BASE_UNIT_CONNECTION_PASSAGE = ConnectionRemote.class;
    public static final Class<? extends AgentRemote> UNIT_BASE_AGENT = BASE_UNIT_AGENT;
    public static final Class<? extends AppRemote> UNIT_BASE_APP = BASE_UNIT_APP;
    public static final Class<? extends SceneRemote> UNIT_BASE_SCENE = BASE_UNIT_SCENE;
    public static final Class<? extends UnitGroupRemote> UNIT_UNITGROUP = BASE_UNIT_UNITGROUP;
    public static final Class<? extends UserRemote> UNIT_BASE_USER = BASE_UNIT_USER;
    public static final Class<? extends DeviceRemote> UNIT_BASE_DEVICE = BASE_UNIT_DEVICE;
    public static final Class<? extends LocationRemote> UNIT_BASE_LOCATION = BASE_UNIT_LOCATION;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION = BASE_UNIT_CONNECTION;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION_DOOR = BASE_UNIT_CONNECTION;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION_WINDOW = BASE_UNIT_CONNECTION;
    public static final Class<? extends ConnectionRemote> UNIT_BASE_CONNECTION_PASSAGE = BASE_UNIT_CONNECTION;
    public static final Class<? extends AgentRemote> AGENT = BASE_UNIT_AGENT;
    public static final Class<? extends AppRemote> APP = BASE_UNIT_APP;
    public static final Class<? extends SceneRemote> SCENE = BASE_UNIT_SCENE;
    public static final Class<? extends UnitGroupRemote> UNITGROUP = BASE_UNIT_UNITGROUP;
    public static final Class<? extends UserRemote> USER = BASE_UNIT_USER;
    public static final Class<? extends DeviceRemote> DEVICE = BASE_UNIT_DEVICE;
    public static final Class<? extends LocationRemote> LOCATION = BASE_UNIT_LOCATION;
    public static final Class<? extends ConnectionRemote> DOOR = BASE_UNIT_CONNECTION;
    public static final Class<? extends ConnectionRemote> WINDOW = BASE_UNIT_CONNECTION;
    public static final Class<? extends ConnectionRemote> PASSAGE = BASE_UNIT_CONNECTION;
    public static final Class<? extends ConnectionRemote> CONNECTION = BASE_UNIT_CONNECTION;
    public static final Class<? extends LightRemote> DAL_UNIT_LIGHT = LightRemote.class;
    public static final Class<? extends LightSensorRemote> DAL_UNIT_LIGHT_SENSOR = LightSensorRemote.class;
    public static final Class<? extends ColorableLightRemote> DAL_UNIT_COLORABLE_LIGHT = ColorableLightRemote.class;
    public static final Class<? extends DimmableLightRemote> DAL_UNIT_DIMMABLE_LIGHT = DimmableLightRemote.class;
    public static final Class<? extends DimmerRemote> DAL_UNIT_DIMMER = DimmerRemote.class;
    public static final Class<? extends MotionDetectorRemote> DAL_UNIT_MOTION_DETECTOR = MotionDetectorRemote.class;
    public static final Class<? extends PowerSwitchRemote> DAL_UNIT_POWER_SWITCH = PowerSwitchRemote.class;
    public static final Class<? extends PowerConsumptionSensorRemote> DAL_UNIT_POWER_CONSUMPTION_SENSOR = PowerConsumptionSensorRemote.class;
    public static final Class<? extends ButtonRemote> DAL_UNIT_BUTTON = ButtonRemote.class;
    public static final Class<? extends TemperatureControllerRemote> DAL_UNIT_TEMPERATURE_CONTROLLER = TemperatureControllerRemote.class;
    public static final Class<? extends TemperatureSensorRemote> DAL_UNIT_TEMPERATURE_SENSOR = TemperatureSensorRemote.class;
    public static final Class<? extends BatteryRemote> DAL_UNIT_BATTERY = BatteryRemote.class;
    public static final Class<? extends HandleRemote> DAL_UNIT_HANDLE = HandleRemote.class;
    public static final Class<? extends MonitorRemote> DAL_UNIT_MONITOR = MonitorRemote.class;
    public static final Class<? extends ReedContactRemote> DAL_UNIT_REED_CONTACT = ReedContactRemote.class;
    public static final Class<? extends RollerShutterRemote> DAL_UNIT_ROLLER_SHUTTER = RollerShutterRemote.class;
    public static final Class<? extends SmokeDetectorRemote> DAL_UNIT_SMOKE_DETECTOR = SmokeDetectorRemote.class;
    public static final Class<? extends TamperDetectorRemote> DAL_UNIT_TAMPER_DETECTOR = TamperDetectorRemote.class;
    public static final Class<? extends LightRemote> UNIT_DAL_LIGHT = DAL_UNIT_LIGHT;
    public static final Class<? extends LightSensorRemote> UNIT_DAL_LIGHT_SENSOR = DAL_UNIT_LIGHT_SENSOR;
    public static final Class<? extends ColorableLightRemote> UNIT_DAL_LIGHT_COLORABLE = DAL_UNIT_COLORABLE_LIGHT;
    public static final Class<? extends DimmableLightRemote> UNIT_DAL_LIGHT_DIMMABLE = DAL_UNIT_DIMMABLE_LIGHT;
    public static final Class<? extends DimmerRemote> UNIT_DAL_DIMMER = DAL_UNIT_DIMMER;
    public static final Class<? extends MotionDetectorRemote> UNIT_DAL_MOTION_DETECTOR = DAL_UNIT_MOTION_DETECTOR;
    public static final Class<? extends PowerSwitchRemote> UNIT_DAL_POWER_SWITCH = DAL_UNIT_POWER_SWITCH;
    public static final Class<? extends PowerConsumptionSensorRemote> UNIT_DAL_POWER_CONSUMPTION_SENSOR = DAL_UNIT_POWER_CONSUMPTION_SENSOR;
    public static final Class<? extends ButtonRemote> UNIT_DAL_BUTTON = DAL_UNIT_BUTTON;
    public static final Class<? extends TemperatureControllerRemote> UNIT_DAL_TEMPERATURE_CONTROLLER = DAL_UNIT_TEMPERATURE_CONTROLLER;
    public static final Class<? extends TemperatureSensorRemote> UNIT_DAL_TEMPERATURE_SENSOR = DAL_UNIT_TEMPERATURE_SENSOR;
    public static final Class<? extends BatteryRemote> UNIT_DAL_BATTERY = DAL_UNIT_BATTERY;
    public static final Class<? extends HandleRemote> UNIT_DAL_HANDLE = DAL_UNIT_HANDLE;
    public static final Class<? extends MonitorRemote> UNIT_DAL_MONITOR = DAL_UNIT_MONITOR;
    public static final Class<? extends ReedContactRemote> UNIT_DAL_REED_CONTACT = DAL_UNIT_REED_CONTACT;
    public static final Class<? extends RollerShutterRemote> UNIT_DAL_ROLLER_SHUTTER = DAL_UNIT_ROLLER_SHUTTER;
    public static final Class<? extends SmokeDetectorRemote> UNIT_DAL_SMOKE_DETECTOR = DAL_UNIT_SMOKE_DETECTOR;
    public static final Class<? extends TamperDetectorRemote> UNIT_DAL_TAMPER_DETECTOR = DAL_UNIT_TAMPER_DETECTOR;
    public static final Class<? extends LightRemote> LIGHT = DAL_UNIT_LIGHT;
    public static final Class<? extends LightSensorRemote> LIGHT_SENSOR = DAL_UNIT_LIGHT_SENSOR;
    public static final Class<? extends ColorableLightRemote> LIGHT_COLORABLE = DAL_UNIT_COLORABLE_LIGHT;
    public static final Class<? extends ColorableLightRemote> COLORABLE_LIGHT = DAL_UNIT_COLORABLE_LIGHT;
    public static final Class<? extends DimmableLightRemote> LIGHT_DIMMABLE = DAL_UNIT_DIMMABLE_LIGHT;
    public static final Class<? extends DimmableLightRemote> DIMMABLE_LIGHT = DAL_UNIT_DIMMABLE_LIGHT;
    public static final Class<? extends DimmerRemote> DIMMER = DAL_UNIT_DIMMER;
    public static final Class<? extends MotionDetectorRemote> MOTION_DETECTOR = DAL_UNIT_MOTION_DETECTOR;
    public static final Class<? extends PowerSwitchRemote> POWER_SWITCH = DAL_UNIT_POWER_SWITCH;
    public static final Class<? extends PowerConsumptionSensorRemote> POWER_CONSUMPTION_SENSOR = DAL_UNIT_POWER_CONSUMPTION_SENSOR;
    public static final Class<? extends ButtonRemote> BUTTON = DAL_UNIT_BUTTON;
    public static final Class<? extends TemperatureControllerRemote> TEMPERATURE_CONTROLLER = DAL_UNIT_TEMPERATURE_CONTROLLER;
    public static final Class<? extends TemperatureSensorRemote> TEMPERATURE_SENSOR = DAL_UNIT_TEMPERATURE_SENSOR;
    public static final Class<? extends BatteryRemote> BATTERY = DAL_UNIT_BATTERY;
    public static final Class<? extends HandleRemote> HANDLE = DAL_UNIT_HANDLE;
    public static final Class<? extends MonitorRemote> MONITOR = DAL_UNIT_MONITOR;
    public static final Class<? extends ReedContactRemote> REED_CONTACT = DAL_UNIT_REED_CONTACT;
    public static final Class<? extends RollerShutterRemote> ROLLER_SHUTTER = DAL_UNIT_ROLLER_SHUTTER;
    public static final Class<? extends SmokeDetectorRemote> SMOKE_DETECTOR = DAL_UNIT_SMOKE_DETECTOR;
    public static final Class<? extends TamperDetectorRemote> TAMPER_DETECTOR = DAL_UNIT_TAMPER_DETECTOR;
    public static Units instance;
    private static final ReentrantReadWriteLock UNIT_REMOTE_REGISTRY_LOCK;
    private static final UnitRemoteFactory UNIT_REMOTE_FACTORY;
    private static RemoteControllerRegistry<String, UnitRemote<? extends GeneratedMessage>> unitRemoteRegistry;
    public static final SyncObject UNIT_POOL_LOCK;

    public static void reset(Object responsibleObject) throws CouldNotPerformException {
        try {
            if (!JPService.testMode()) {
                throw new FatalImplementationErrorException("Units can only be reseted in test mode!", responsibleObject);
            }
            ((Stream)unitRemoteRegistry.getEntries().stream().parallel()).forEach(unitRemote -> {
                try {
                    unitRemote.unlock(unitRemoteRegistry);
                    unitRemote.shutdown();
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)("Could not properly shutdown " + unitRemote), (Throwable)ex, (Logger)LOGGER);
                }
            });
            unitRemoteRegistry.clear();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not reset Units!", (Throwable)ex);
        }
    }

    public static synchronized UnitRegistry getUnitRegistry() throws InterruptedException, CouldNotPerformException {
        Registries.getUnitRegistry().waitForData();
        return Registries.getUnitRegistry();
    }

    private static UnitRemote<?> getUnitRemote(String unitId) throws NotAvailableException, InterruptedException {
        try {
            UnitRemote unitRemote;
            boolean newInstance;
            UNIT_REMOTE_REGISTRY_LOCK.writeLock().lock();
            try {
                if (!unitRemoteRegistry.contains((Object)unitId)) {
                    newInstance = true;
                    unitRemote = UNIT_REMOTE_FACTORY.newInitializedInstance(Units.getUnitRegistry().getUnitConfigById(unitId));
                    unitRemoteRegistry.register((Identifiable)unitRemote);
                } else {
                    newInstance = false;
                    unitRemote = (UnitRemote)unitRemoteRegistry.get((Object)unitId);
                }
            }
            finally {
                UNIT_REMOTE_REGISTRY_LOCK.writeLock().unlock();
            }
            if (newInstance && unitRemote.isEnabled()) {
                unitRemote.activate();
                unitRemote.lock(unitRemoteRegistry);
            }
            return unitRemote;
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("UnitRemote[" + unitId + "]", ex);
        }
    }

    private static UnitRemote<?> getUnitRemote(UnitConfigType.UnitConfig unitConfig) throws NotAvailableException, InterruptedException {
        try {
            UnitRemote unitRemote;
            boolean newInstance;
            UNIT_REMOTE_REGISTRY_LOCK.writeLock().lock();
            try {
                if (!unitRemoteRegistry.contains((Object)unitConfig.getId())) {
                    newInstance = true;
                    unitRemote = UNIT_REMOTE_FACTORY.newInitializedInstance(unitConfig);
                    unitRemoteRegistry.register((Identifiable)unitRemote);
                } else {
                    newInstance = false;
                    unitRemote = (UnitRemote)unitRemoteRegistry.get((Object)unitConfig.getId());
                }
            }
            finally {
                UNIT_REMOTE_REGISTRY_LOCK.writeLock().unlock();
            }
            if (newInstance && unitRemote.isEnabled()) {
                unitRemote.activate();
                unitRemote.lock(unitRemoteRegistry);
            }
            return unitRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("UnitRemote[" + unitConfig.getId() + "]", (Throwable)ex);
        }
    }

    private static UnitRemote<?> waitForData(UnitRemote<?> unitRemote, boolean waitForData) throws CouldNotPerformException, InterruptedException {
        if (waitForData) {
            unitRemote.waitForData();
        }
        return unitRemote;
    }

    public static UnitRemote<?> getUnit(String unitId, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (unitId == null) {
                assert (false);
                throw new NotAvailableException("UnitId");
            }
            return Units.waitForData(Units.getUnitRemote(unitId), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + unitId + "]", (Throwable)ex);
        }
    }

    public static UnitRemote<?> getUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (unitConfig == null) {
                assert (false);
                throw new NotAvailableException("UnitConfig");
            }
            return Units.waitForData(Units.getUnitRemote(unitConfig), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + unitConfig.getId() + "|" + unitConfig.getLabel() + "]", (Throwable)ex);
        }
    }

    public static <UR extends UnitRemote<?>> UR getUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            return (UR)Units.getUnit(unitConfig, waitForData);
        }
        catch (ClassCastException ex) {
            throw new NotAvailableException("Unit[" + unitConfig.getId() + "]", (Throwable)new InvalidStateException("Requested Unit[" + unitConfig.getLabel() + "] of UnitType[" + unitConfig.getType() + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex));
        }
    }

    public static <UR extends UnitRemote<?>> UR getUnit(String unitId, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            return (UR)Units.getUnit(unitId, waitForData);
        }
        catch (ClassCastException ex) {
            throw new NotAvailableException("Unit[" + unitId + "]", (Throwable)new InvalidStateException("Requested Unit[" + unitId + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex));
        }
    }

    public static List<UnitRemote<?>> getUnitsByLabelAndType(String label, UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            ArrayList unitRemoteList = new ArrayList();
            for (UnitConfigType.UnitConfig unitConfig : Units.getUnitRegistry().getUnitConfigsByLabelAndUnitType(label, unitType)) {
                unitRemoteList.add(Units.getUnit(unitConfig, waitForData));
            }
            return unitRemoteList;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    @Deprecated
    public static UnitRemote<?> getUnitByLabelAndType(String label, UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            List unitConfigList = Units.getUnitRegistry().getUnitConfigsByLabelAndUnitType(label, unitType);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("No configuration found in registry!");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit is not unique! Please specify the unit location in order to unique resolve the unit configuration.");
            }
            return Units.getUnit((UnitConfigType.UnitConfig)unitConfigList.get(0), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static List<UnitRemote<?>> getUnitsByLabel(String label, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            ArrayList unitRemoteList = new ArrayList();
            for (UnitConfigType.UnitConfig unitConfig : Units.getUnitRegistry().getUnitConfigsByLabel(label)) {
                unitRemoteList.add(Units.getUnit(unitConfig, waitForData));
            }
            return unitRemoteList;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    @Deprecated
    public static UnitRemote<?> getUnitByLabel(String label, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitName");
            }
            List unitConfigList = Units.getUnitRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("No configuration found in registry!");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit is not unique! Please specify the unit location in order to unique resolve the unit configuration.");
            }
            return Units.getUnit((UnitConfigType.UnitConfig)unitConfigList.get(0), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static <UR extends UnitRemote<?>> List<UR> getUnitsByLabel(String label, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            try {
                return Units.getUnitsByLabelAndType(label, Units.getUnitTypeByRemoteClass(unitRemoteClass), waitForData);
            }
            catch (ClassCastException ex) {
                throw new InvalidStateException("Requested Unit[" + label + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    @Deprecated
    public static <UR extends UnitRemote<?>> UR getUnitByLabel(String label, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        try {
            try {
                return (UR)Units.getUnitsByLabelAndType(label, Units.getUnitTypeByRemoteClass(unitRemoteClass), waitForData).get(0);
            }
            catch (ClassCastException ex) {
                throw new InvalidStateException("Requested Unit[" + label + "] is not compatible with defined UnitRemoteClass[" + unitRemoteClass + "]!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static UnitRemote<?> getUnitByScope(ScopeType.Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnit(Units.getUnitRegistry().getUnitConfigByScope(scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            try {
                throw new NotAvailableException("Unit[" + ScopeGenerator.generateStringRep((ScopeType.Scope)scope) + "]", (Throwable)ex);
            }
            catch (CouldNotPerformException ex1) {
                throw new NotAvailableException("Unit[?]", (Throwable)ex);
            }
        }
    }

    public static UnitRemote<?> getUnitByScope(Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnitByScope(ScopeTransformer.transform((Scope)scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + scope + "]", (Throwable)ex);
        }
    }

    public static UnitRemote<?> getUnitByScope(String scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (scope == null) {
                assert (false);
                throw new NotAvailableException("UnitScope");
            }
            return Units.getUnitByScope(ScopeGenerator.generateScope((String)scope), waitForData);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + scope + "]", (Throwable)ex);
        }
    }

    public UnitRemote<?> getUnitByLabelAndLocationScope(String label, String locationScope, boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            if (label == null) {
                assert (false);
                throw new NotAvailableException("UnitLabel");
            }
            if (locationScope == null) {
                assert (false);
                throw new NotAvailableException("UnitLocationScope");
            }
            for (UnitConfigType.UnitConfig unitConfig : Units.getUnitRegistry().getUnitConfigsByLabel(label)) {
                if (!ScopeGenerator.generateStringRep((ScopeType.Scope)Units.getUnitRegistry().getUnitConfigById(unitConfig.getPlacementConfig().getLocationId()).getScope()).equals(locationScope)) continue;
                return Units.getUnit(unitConfig, waitForData);
            }
            throw new InvalidStateException("No unit with Label[" + label + "] found at Location[" + locationScope + "]");
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit[" + label + "]", (Throwable)ex);
        }
    }

    public static Future<UnitRemote<?>> getFutureUnit(String unitId, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnit(unitId, waitForData));
    }

    public static Future<UnitRemote<?>> getFutureUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnit(unitConfig, waitForData));
    }

    public static <UR extends UnitRemote<?>> Future<UR> getFutureUnit(UnitConfigType.UnitConfig unitConfig, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnit(unitConfig, waitForData, unitRemoteClass));
    }

    public static <UR extends UnitRemote<?>> Future<UR> getFutureUnit(String unitId, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnit(unitId, waitForData, unitRemoteClass));
    }

    public static Future<List<UnitRemote<?>>> getFutureUnitsByLabelAndType(String label, UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitsByLabelAndType(label, unitType, waitForData));
    }

    public static Future<List<UnitRemote<?>>> getFutureUnitsByLabel(String label, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitsByLabel(label, waitForData));
    }

    public static <UR extends UnitRemote<?>> Future<List<UR>> getFutureUnitsByLabel(String label, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitsByLabel(label, waitForData, unitRemoteClass));
    }

    @Deprecated
    public static Future<UnitRemote> getFutureUnitByLabelAndType(String label, UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitByLabelAndType(label, unitType, waitForData));
    }

    @Deprecated
    public static Future<UnitRemote> getFutureUnitByLabel(String label, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitByLabel(label, waitForData));
    }

    @Deprecated
    public static <UR extends UnitRemote<?>> Future<UR> getFutureUnitByLabel(String label, boolean waitForData, Class<UR> unitRemoteClass) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitByLabel(label, waitForData, unitRemoteClass));
    }

    public static Future<UnitRemote<?>> getFutureUnitByScope(ScopeType.Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitByScope(scope, waitForData));
    }

    public static Future<UnitRemote<?>> getFutureUnitByScope(Scope scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitByScope(scope, waitForData));
    }

    public static Future<UnitRemote<?>> getFutureUnitByScope(String scope, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> Units.getUnitByScope(scope, waitForData));
    }

    public Future<UnitRemote<?>> getFutureUnitByLabelAndLocationScope(String label, String locationScope, boolean waitForData) throws NotAvailableException, InterruptedException {
        return GlobalCachedExecutorService.submit(() -> this.getUnitByLabelAndLocationScope(label, locationScope, waitForData));
    }

    public static UnitTemplateType.UnitTemplate.UnitType getUnitTypeByRemoteClass(Class<? extends UnitRemote<?>> unitRemoteClass) throws CouldNotPerformException {
        try {
            return UnitTemplateType.UnitTemplate.UnitType.valueOf((String)StringProcessor.transformToUpperCase((String)unitRemoteClass.getSimpleName().replaceAll("Remote", "")));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw new CouldNotPerformException("Could not resolve unit type out of UnitRemoteClass[" + unitRemoteClass.getName() + "]", (Throwable)ex);
        }
    }

    public static boolean contains(UnitRemote<? extends GeneratedMessage> unitRemote) throws CouldNotPerformException {
        return unitRemoteRegistry.contains(unitRemote);
    }

    public static Future<Transform> getUnitTransformation(UnitConfigType.UnitConfig unitConfig) throws InterruptedException {
        try {
            CompletableFuture dataFuture = Registries.getLocationRegistry().getDataFuture();
            return GlobalCachedExecutorService.allOfInclusiveResultFuture((Future)Registries.getLocationRegistry().getUnitTransformation(unitConfig), (Future[])new Future[]{dataFuture});
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture(Transform.class, (Exception)((Object)new NotAvailableException("UnitTransformation", (Throwable)ex)));
        }
    }

    public static Future<Transform> getUnitTransformation(UnitConfigType.UnitConfig unitConfigA, UnitConfigType.UnitConfig unitConfigB) throws InterruptedException {
        try {
            CompletableFuture dataFuture = Registries.getLocationRegistry().getDataFuture();
            return GlobalCachedExecutorService.allOfInclusiveResultFuture((Future)Registries.getLocationRegistry().getUnitTransformation(unitConfigA, unitConfigB), (Future[])new Future[]{dataFuture});
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture(Transform.class, (Exception)((Object)new NotAvailableException("UnitTransformation", (Throwable)ex)));
        }
    }

    static {
        UNIT_REMOTE_REGISTRY_LOCK = new ReentrantReadWriteLock();
        UNIT_REMOTE_FACTORY = UnitRemoteFactoryImpl.getInstance();
        UNIT_POOL_LOCK = new SyncObject("UnitPoolLock");
        try {
            unitRemoteRegistry = new RemoteControllerRegistry();
            Shutdownable.registerShutdownHook((Shutdownable)new Shutdownable(){

                public void shutdown() {
                    try {
                        ((Stream)unitRemoteRegistry.getEntries().stream().parallel()).forEach(unitRemote -> {
                            try {
                                unitRemote.unlock((Object)unitRemoteRegistry);
                                unitRemote.shutdown();
                            }
                            catch (CouldNotPerformException ex) {
                                ExceptionPrinter.printHistory((String)("Could not properly shutdown " + unitRemote), (Throwable)ex, (Logger)LOGGER);
                            }
                        });
                    }
                    catch (Exception ex) {
                        ExceptionPrinter.printHistory((String)"Could not properly shutdown remote pool!", (Throwable)ex, (Logger)LOGGER);
                    }
                    finally {
                        unitRemoteRegistry.shutdown();
                    }
                }

                public String toString() {
                    return "UnitRemotePool";
                }
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException(Units.class, (Throwable)new InstantiationException(Units.class, (Throwable)ex)), (Logger)LOGGER);
        }
    }
}

