/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.service.collection.ActivationStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.ActivationStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.unit.UnitTemplateType;

public class ActivationStateServiceRemote
extends AbstractServiceRemote<ActivationStateOperationService, ActivationStateType.ActivationState>
implements ActivationStateOperationServiceCollection {
    public ActivationStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.ACTIVATION_STATE_SERVICE, ActivationStateType.ActivationState.class);
    }

    public Collection<ActivationStateOperationService> getActivationStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected ActivationStateType.ActivationState computeServiceState() throws CouldNotPerformException {
        return this.getActivationState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public ActivationStateType.ActivationState getActivationState() throws NotAvailableException {
        return (ActivationStateType.ActivationState)this.getData();
    }

    public ActivationStateType.ActivationState getActivationState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        ActivationStateType.ActivationState.State activationStateValue = ActivationStateType.ActivationState.State.DEACTIVE;
        try {
            for (ActivationStateOperationService service : this.getServices(unitType)) {
                if (!((UnitRemote)service).isDataAvailable() || service.getActivationState().getValue() != ActivationStateType.ActivationState.State.ACTIVE) continue;
                activationStateValue = ActivationStateType.ActivationState.State.ACTIVE;
            }
            return ((ActivationStateType.ActivationState.Builder)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(activationStateValue))).build();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("ActivationState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setActivationState(ActivationStateType.ActivationState activationState) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(super.getServices(), input -> input.setActivationState(activationState));
    }

    public Future<ActionFutureType.ActionFuture> setActivationState(ActivationStateType.ActivationState activationState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(super.getServices(unitType), input -> input.setActivationState(activationState));
    }
}

