/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.collection.BlindStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.BlindStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.unit.UnitTemplateType;

public class BlindStateServiceRemote
extends AbstractServiceRemote<BlindStateOperationService, BlindStateType.BlindState>
implements BlindStateOperationServiceCollection {
    public BlindStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.BLIND_STATE_SERVICE, BlindStateType.BlindState.class);
    }

    public Collection<BlindStateOperationService> getBlindStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected BlindStateType.BlindState computeServiceState() throws CouldNotPerformException {
        return this.getBlindState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public BlindStateType.BlindState getBlindState() throws NotAvailableException {
        return (BlindStateType.BlindState)this.getData();
    }

    public BlindStateType.BlindState getBlindState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        int serviceNumber = this.getBlindStateOperationServices().size();
        int stop = 0;
        int down = 0;
        int up = 0;
        long timestamp = 0L;
        float openingRatioAverage = 0.0f;
        for (BlindStateOperationService service : this.getBlindStateOperationServices()) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            switch (service.getBlindState().getMovementState()) {
                case DOWN: {
                    ++down;
                    break;
                }
                case STOP: {
                    ++stop;
                    break;
                }
                case UP: {
                    ++up;
                }
            }
            openingRatioAverage = (float)((double)openingRatioAverage + service.getBlindState().getOpeningRatio());
            timestamp = Math.max(timestamp, service.getBlindState().getTimestamp().getTime());
        }
        BlindStateType.BlindState.MovementState mostOccurences = stop >= up && stop >= down ? BlindStateType.BlindState.MovementState.STOP : (up >= stop && up >= down ? BlindStateType.BlindState.MovementState.UP : BlindStateType.BlindState.MovementState.DOWN);
        return ((BlindStateType.BlindState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)BlindStateType.BlindState.newBuilder().setMovementState(mostOccurences).setOpeningRatio((double)(openingRatioAverage /= (float)serviceNumber)), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }

    public Future<ActionFutureType.ActionFuture> setBlindState(BlindStateType.BlindState state) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(super.getServices(), input -> input.setBlindState(state));
    }

    public Future<ActionFutureType.ActionFuture> setBlindState(BlindStateType.BlindState state, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(super.getServices(unitType), input -> input.setBlindState(state));
    }
}

