/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.collection.TargetTemperatureStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.TargetTemperatureStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitTemplateType;

public class TargetTemperatureStateServiceRemote
extends AbstractServiceRemote<TargetTemperatureStateOperationService, TemperatureStateType.TemperatureState>
implements TargetTemperatureStateOperationServiceCollection {
    public TargetTemperatureStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.TARGET_TEMPERATURE_STATE_SERVICE, TemperatureStateType.TemperatureState.class);
    }

    public Collection<TargetTemperatureStateOperationService> getTargetTemperatureStateOperationServices() {
        return this.getServices();
    }

    public Future<ActionFutureType.ActionFuture> setTargetTemperatureState(TemperatureStateType.TemperatureState temperatureState) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(this.getServices(), input -> input.setTargetTemperatureState(temperatureState));
    }

    public Future<ActionFutureType.ActionFuture> setTargetTemperatureState(TemperatureStateType.TemperatureState temperatureState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        return GlobalCachedExecutorService.allOf(this.getServices(unitType), input -> input.setTargetTemperatureState(temperatureState));
    }

    @Override
    protected TemperatureStateType.TemperatureState computeServiceState() throws CouldNotPerformException {
        return this.getTargetTemperatureState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public TemperatureStateType.TemperatureState getTargetTemperatureState() throws NotAvailableException {
        return (TemperatureStateType.TemperatureState)this.getData();
    }

    public TemperatureStateType.TemperatureState getTargetTemperatureState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        Double average = 0.0;
        Collection targetTemperatureStateOperationServices = this.getServices(unitType);
        int amount = targetTemperatureStateOperationServices.size();
        long timestamp = 0L;
        for (TargetTemperatureStateOperationService service : targetTemperatureStateOperationServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            average = average + service.getTargetTemperatureState().getTemperature();
            timestamp = Math.max(timestamp, service.getTargetTemperatureState().getTimestamp().getTime());
        }
        average = average / (double)amount;
        return ((TemperatureStateType.TemperatureState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)TemperatureStateType.TemperatureState.newBuilder().setTemperature(average.doubleValue()), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

