/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit.location;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.service.ServiceRemote;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.lib.layer.unit.location.Location;
import org.openbase.bco.dal.remote.service.ServiceRemoteManager;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.iface.provider.LabelProvider;
import org.openbase.jul.pattern.Observable;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.SnapshotType;
import rst.domotic.service.ServiceDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.AlarmStateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.state.MotionStateType;
import rst.domotic.state.PowerConsumptionStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.state.SmokeStateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.state.TamperStateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.connection.ConnectionConfigType;
import rst.domotic.unit.location.LocationConfigType;
import rst.domotic.unit.location.LocationDataType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class LocationRemote
extends AbstractUnitRemote<LocationDataType.LocationData>
implements Location {
    private final ServiceRemoteManager serviceRemoteManager = new ServiceRemoteManager((LabelProvider)this){

        @Override
        protected Set<ServiceTemplateType.ServiceTemplate.ServiceType> getManagedServiceTypes() throws NotAvailableException, InterruptedException {
            return LocationRemote.this.getSupportedServiceTypes();
        }

        @Override
        protected void notifyServiceUpdate(Observable source, Object data) throws NotAvailableException, InterruptedException {
        }
    };

    public LocationRemote() {
        super(LocationDataType.LocationData.class);
    }

    @Override
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        UnitConfigType.UnitConfig unitConfig = super.applyConfigUpdate(config);
        this.serviceRemoteManager.applyConfigUpdate((List<String>)unitConfig.getLocationConfig().getUnitIdList());
        return unitConfig;
    }

    @Override
    public void activate() throws InterruptedException, CouldNotPerformException {
        CachedLocationRegistryRemote.waitForData();
        this.serviceRemoteManager.activate();
        super.activate();
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        this.serviceRemoteManager.deactivate();
        super.deactivate();
    }

    public Future<SnapshotType.Snapshot> recordSnapshot(UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)unitType, (RSBRemote)this, SnapshotType.Snapshot.class);
    }

    public Future<Void> restoreSnapshot(SnapshotType.Snapshot snapshot) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)snapshot, (RSBRemote)this, Void.class);
    }

    @Override
    public Future<ActionFutureType.ActionFuture> applyAction(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)actionDescription, (RSBRemote)this, ActionFutureType.ActionFuture.class);
    }

    public ServiceRemote getServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws NotAvailableException {
        return this.serviceRemoteManager.getServiceRemote(serviceType);
    }

    @Deprecated
    public List<String> getNeighborLocationIds() throws CouldNotPerformException {
        ArrayList<String> neighborIdList = new ArrayList<String>();
        try {
            for (UnitConfigType.UnitConfig locationConfig : CachedLocationRegistryRemote.getRegistry().getNeighborLocations(this.getId())) {
                neighborIdList.add(locationConfig.getId());
            }
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Could not get CachedLocationRegistryRemote!", (Throwable)ex);
        }
        return neighborIdList;
    }

    public List<LocationRemote> getNeighborLocationList(boolean waitForData) throws CouldNotPerformException {
        ArrayList<LocationRemote> neighborList = new ArrayList<LocationRemote>();
        try {
            for (UnitConfigType.UnitConfig locationUnitConfig : CachedLocationRegistryRemote.getRegistry().getNeighborLocations(this.getId())) {
                neighborList.add(Units.getUnit(locationUnitConfig, waitForData, Units.LOCATION));
            }
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Could not get all neighbors!", (Throwable)ex);
        }
        return neighborList;
    }

    public List<LocationRemote> getChildLocationList(boolean waitForData) throws CouldNotPerformException {
        ArrayList<LocationRemote> childList = new ArrayList<LocationRemote>();
        for (String childId : ((UnitConfigType.UnitConfig)this.getConfig()).getLocationConfig().getChildIdList()) {
            try {
                childList.add(Units.getUnit(CachedLocationRegistryRemote.getRegistry().getLocationConfigById(childId), waitForData, Units.LOCATION));
            }
            catch (InterruptedException ex) {
                throw new CouldNotPerformException("Could not get all child locations!", (Throwable)ex);
            }
        }
        return childList;
    }

    public List<ConnectionRemote> getConnectionList(boolean waitForData) throws CouldNotPerformException {
        if (!((UnitConfigType.UnitConfig)this.getConfig()).getLocationConfig().getType().equals((Object)LocationConfigType.LocationConfig.LocationType.TILE)) {
            throw new CouldNotPerformException("Location is not a Tile!");
        }
        ArrayList<ConnectionRemote> connectionList = new ArrayList<ConnectionRemote>();
        try {
            for (UnitConfigType.UnitConfig connectionUnitConfig : CachedLocationRegistryRemote.getRegistry().getConnectionConfigs()) {
                ConnectionRemote connection = Units.getUnit(connectionUnitConfig, waitForData, Units.CONNECTION);
                if (!((UnitConfigType.UnitConfig)connection.getConfig()).getConnectionConfig().getTileIdList().contains((Object)this.getId())) continue;
                connectionList.add(connection);
            }
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Could not get all connections!", (Throwable)ex);
        }
        return connectionList;
    }

    public List<ConnectionRemote> getDirectConnectionList(String locationID, boolean waitForData) throws CouldNotPerformException {
        if (!((UnitConfigType.UnitConfig)this.getConfig()).getLocationConfig().getType().equals((Object)LocationConfigType.LocationConfig.LocationType.TILE)) {
            throw new CouldNotPerformException("Location is not a Tile!");
        }
        ArrayList<ConnectionRemote> connectionList = new ArrayList<ConnectionRemote>();
        try {
            for (UnitConfigType.UnitConfig connectionUnitConfig : Registries.getLocationRegistry().getConnectionConfigs()) {
                ConnectionRemote connection = Units.getUnit(connectionUnitConfig, waitForData, Units.CONNECTION);
                if (!connectionUnitConfig.getConnectionConfig().getTileIdList().contains((Object)this.getId()) || !connectionUnitConfig.getConnectionConfig().getTileIdList().contains((Object)locationID)) continue;
                connectionList.add(connection);
            }
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Could not get all connections!", (Throwable)ex);
        }
        return connectionList;
    }

    public boolean hasDirectConnection(String locationID, ConnectionConfigType.ConnectionConfig.ConnectionType connectionType, boolean waitForData) throws CouldNotPerformException {
        for (ConnectionRemote relatedConnection : this.getDirectConnectionList(locationID, true)) {
            if (!((UnitConfigType.UnitConfig)relatedConnection.getConfig()).getConnectionConfig().getType().equals((Object)connectionType)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Map<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> getProvidedUnitMap() throws NotAvailableException, InterruptedException {
        return this.getUnitMap();
    }

    public Map<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> getUnitMap() throws NotAvailableException, InterruptedException {
        return this.getUnitMap(true);
    }

    public Map<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> getUnitMap(boolean recursive) throws NotAvailableException, InterruptedException {
        try {
            TreeMap<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> unitRemoteMap = new TreeMap<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>>();
            MultiException.ExceptionStack exceptionStack = null;
            for (String unitId : ((UnitConfigType.UnitConfig)this.getConfig()).getLocationConfig().getUnitIdList()) {
                try {
                    UnitRemote<?> unitRemote = Units.getUnit(unitId, false);
                    if (!recursive && !((UnitConfigType.UnitConfig)unitRemote.getConfig()).getPlacementConfig().getLocationId().equals(this.getId())) continue;
                    if (!unitRemoteMap.containsKey(unitRemote.getUnitType())) {
                        unitRemoteMap.put(unitRemote.getUnitType(), new ArrayList());
                    }
                    ((List)unitRemoteMap.get(unitRemote.getUnitType())).add(unitRemote);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex), exceptionStack);
                }
            }
            try {
                MultiException.checkAndThrow((String)("Could not collect all unit remotes of " + (Object)((Object)this)), exceptionStack);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.WARN);
            }
            return unitRemoteMap;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Unit map of " + (Object)((Object)this), (Throwable)ex);
        }
    }

    public <UR extends UnitRemote<?>> Collection<UR> getUnits(UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData, Class<UR> unitRemoteClass) throws CouldNotPerformException, InterruptedException {
        return this.getUnits(unitType, waitForData, unitRemoteClass, true);
    }

    public <UR extends UnitRemote<?>> Collection<UR> getUnits(UnitTemplateType.UnitTemplate.UnitType unitType, boolean waitForData, Class<UR> unitRemoteClass, boolean recursive) throws CouldNotPerformException, InterruptedException {
        ArrayList<UR> unitRemote = new ArrayList<UR>();
        MultiException.ExceptionStack exceptionStack = null;
        Registries.waitForData();
        for (UnitConfigType.UnitConfig unitConfig : Registries.getLocationRegistry().getUnitConfigsByLocation(unitType, this.getId())) {
            try {
                if (!recursive && !unitConfig.getPlacementConfig().getLocationId().equals(this.getId())) continue;
                unitRemote.add(Units.getUnit(unitConfig, waitForData, unitRemoteClass));
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex), exceptionStack);
            }
        }
        try {
            MultiException.checkAndThrow((String)("Could not collect all unit remotes of " + (Object)((Object)this)), exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        return unitRemote;
    }

    public UnitTemplateType.UnitTemplate getTemplate(boolean onlyAvailableServices) throws NotAvailableException {
        if (!onlyAvailableServices) {
            return super.getUnitTemplate();
        }
        UnitTemplateType.UnitTemplate.Builder unitTemplateBuilder = super.getUnitTemplate().toBuilder();
        unitTemplateBuilder.clearServiceDescription();
        for (ServiceDescriptionType.ServiceDescription serviceDescription : super.getUnitTemplate().getServiceDescriptionList()) {
            if (!this.serviceRemoteManager.isServiceAvailable(serviceDescription.getType())) continue;
            unitTemplateBuilder.addServiceDescription(serviceDescription);
        }
        return unitTemplateBuilder.build();
    }

    public Set<ServiceTemplateType.ServiceTemplate.ServiceType> getAvailableServiceTypes() throws NotAvailableException {
        HashSet<ServiceTemplateType.ServiceTemplate.ServiceType> serviceTypeList = new HashSet<ServiceTemplateType.ServiceTemplate.ServiceType>();
        for (ServiceDescriptionType.ServiceDescription serviceDescription : this.getTemplate(true).getServiceDescriptionList()) {
            serviceTypeList.add(serviceDescription.getType());
        }
        return serviceTypeList;
    }

    public Set<ServiceDescriptionType.ServiceDescription> getAvailableServiceDescriptions() throws NotAvailableException {
        HashSet<ServiceDescriptionType.ServiceDescription> serviceDescriptionList = new HashSet<ServiceDescriptionType.ServiceDescription>();
        for (ServiceDescriptionType.ServiceDescription serviceDescription : this.getTemplate(true).getServiceDescriptionList()) {
            serviceDescriptionList.add(serviceDescription);
        }
        return serviceDescriptionList;
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationDataType.LocationData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)HSBColorType.HSBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorStateType.ColorState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorType.Color.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)RGBColorType.RGBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)AlarmStateType.AlarmState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)MotionStateType.MotionState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerConsumptionStateType.PowerConsumptionState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BlindStateType.BlindState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SmokeStateType.SmokeState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)StandbyStateType.StandbyState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TamperStateType.TamperState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TemperatureStateType.TemperatureState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PresenceStateType.PresenceState.getDefaultInstance()));
    }
}

