/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.service.collection.ColorStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.ColorStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.extension.rst.transform.HSBColorToRGBColorTransformer;
import org.slf4j.Logger;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.unit.UnitTemplateType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class ColorStateServiceRemote
extends AbstractServiceRemote<ColorStateOperationService, ColorStateType.ColorState>
implements ColorStateOperationServiceCollection {
    public ColorStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE, ColorStateType.ColorState.class);
    }

    public Collection<ColorStateOperationService> getColorStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected ColorStateType.ColorState computeServiceState() throws CouldNotPerformException {
        return this.getColorState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public Future<ActionFutureType.ActionFuture> setColorState(ColorStateType.ColorState colorState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)colorState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set colorState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setColorState(ColorStateType.ColorState colorState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        serviceStateDescription.setUnitType(unitType);
        try {
            return this.applyAction(Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)colorState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set colorState", (Throwable)ex);
        }
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        return (ColorStateType.ColorState)this.getServiceState();
    }

    public ColorStateType.ColorState getColorState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        try {
            double averageRed = 0.0;
            double averageGreen = 0.0;
            double averageBlue = 0.0;
            int amount = this.getColorStateOperationServices().size();
            long timestamp = 0L;
            Collection colorStateOperationServiceCollection = this.getServices(unitType);
            for (ColorStateOperationService service : colorStateOperationServiceCollection) {
                if (!((UnitRemote)service).isDataAvailable()) {
                    --amount;
                    continue;
                }
                RGBColorType.RGBColor rgbColor = HSBColorToRGBColorTransformer.transform((HSBColorType.HSBColor)service.getColorState().getColor().getHsbColor());
                averageRed += (double)rgbColor.getRed();
                averageGreen += (double)rgbColor.getGreen();
                averageBlue += (double)rgbColor.getBlue();
                timestamp = Math.max(timestamp, service.getColorState().getTimestamp().getTime());
            }
            HSBColorType.HSBColor hsbColor = HSBColorToRGBColorTransformer.transform((RGBColorType.RGBColor)RGBColorType.RGBColor.newBuilder().setRed((int)(averageRed /= (double)amount)).setGreen((int)(averageGreen /= (double)amount)).setBlue((int)(averageBlue /= (double)amount)).build());
            return ((ColorStateType.ColorState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)ColorStateType.ColorState.newBuilder().setColor(ColorType.Color.newBuilder().setType(ColorType.Color.Type.HSB).setHsbColor(hsbColor)), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
        }
        catch (CouldNotTransformException ex) {
            throw new NotAvailableException("Could not transform from HSB to RGB or vice-versa!", (Throwable)ex);
        }
    }
}

