/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.MessageObservable;
import org.openbase.jul.extension.protobuf.processing.GenericMessageProcessor;
import org.openbase.jul.extension.protobuf.processing.MessageProcessor;
import org.openbase.jul.extension.rsb.com.AbstractConfigurableRemote;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.extension.rst.iface.ScopeProvider;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.FutureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rsb.Scope;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.SnapshotType;
import rst.domotic.registry.UnitRegistryDataType;
import rst.domotic.service.ServiceDescriptionType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public abstract class AbstractUnitRemote<D extends GeneratedMessage>
extends AbstractConfigurableRemote<D, UnitConfigType.UnitConfig>
implements UnitRemote<D> {
    private UnitTemplateType.UnitTemplate template;
    private boolean initialized = false;
    private final Observer<UnitRegistryDataType.UnitRegistryData> unitRegistryObserver;
    private final Map<ServiceTemplateType.ServiceTemplate.ServiceType, MessageObservable> serviceStateObservableMap = new HashMap<ServiceTemplateType.ServiceTemplate.ServiceType, MessageObservable>();

    public AbstractUnitRemote(Class<D> dataClass) {
        super(dataClass, UnitConfigType.UnitConfig.class);
        this.unitRegistryObserver = new Observer<UnitRegistryDataType.UnitRegistryData>(){

            public void update(Observable<UnitRegistryDataType.UnitRegistryData> source, UnitRegistryDataType.UnitRegistryData data) throws Exception {
                try {
                    UnitConfigType.UnitConfig newUnitConfig = Registries.getUnitRegistry((boolean)true).getUnitConfigById(AbstractUnitRemote.this.getId());
                    if (!newUnitConfig.equals((Object)AbstractUnitRemote.this.getConfig())) {
                        AbstractUnitRemote.this.applyConfigUpdate(newUnitConfig);
                    }
                }
                catch (NotAvailableException ex) {
                    AbstractUnitRemote.this.logger.debug("Could not update unit remote", (Throwable)ex);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)("Could not update unit config of " + this), (Throwable)ex, (Logger)AbstractUnitRemote.this.logger);
                }
            }
        };
    }

    protected UnitRegistry getUnitRegistry() throws InterruptedException, CouldNotPerformException {
        Registries.getUnitRegistry().waitForData();
        return Registries.getUnitRegistry();
    }

    public void initById(String id) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getUnitRegistry().getUnitConfigById(id));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void initByLabel(String label) throws InitializationException, InterruptedException {
        try {
            List unitConfigList = this.getUnitRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("Unit with Label[" + label + "]");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit with Label[" + label + "] is not unique!");
            }
            this.init((GeneratedMessage)unitConfigList.get(0));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(ScopeType.Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getUnitRegistry().getUnitConfigByScope(scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeTransformer.transform((Scope)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Deprecated
    public void init(String label, ScopeProvider location) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)label, (String)this.getDataClass().getSimpleName(), (ScopeType.Scope)location.getScope()));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            this.setMessageProcessor((MessageProcessor)new GenericMessageProcessor(this.getDataClass()));
            if (!this.initialized) {
                Registries.getUnitRegistry().addDataObserver(this.unitRegistryObserver);
                this.initialized = true;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    protected void notifyDataUpdate(D data) throws CouldNotPerformException {
        super.notifyDataUpdate(data);
        HashSet<ServiceTemplateType.ServiceTemplate.ServiceType> serviceTypeSet = new HashSet<ServiceTemplateType.ServiceTemplate.ServiceType>();
        for (ServiceDescriptionType.ServiceDescription serviceDescription : this.getUnitTemplate().getServiceDescriptionList()) {
            if (serviceTypeSet.contains(serviceDescription.getType())) continue;
            serviceTypeSet.add(serviceDescription.getType());
            try {
                Object serviceData = Services.invokeProviderServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)serviceDescription.getType(), data, (Object[])new Object[0]);
                this.serviceStateObservableMap.get(serviceDescription.getType()).notifyObservers(serviceData);
            }
            catch (CouldNotPerformException ex) {
                this.logger.debug("Could not notify state update for service[" + serviceDescription.getType() + "] because this service is not supported by this remote controller.", (Throwable)ex);
            }
        }
    }

    public void addServiceStateObserver(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Observer observer) {
        this.serviceStateObservableMap.get(serviceType).addObserver(observer);
    }

    public void removeServiceStateObserver(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Observer observer) {
        this.serviceStateObservableMap.get(serviceType).removeObserver(observer);
    }

    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        if (config == null) {
            throw new NotAvailableException("UnitConfig");
        }
        try {
            if (((UnitConfigType.UnitConfig)this.getConfig()).equals((Object)config)) {
                this.logger.debug("Skip config update because no config change detected!");
                return config;
            }
        }
        catch (NotAvailableException ex) {
            this.logger.trace("Unit config change check failed because config is not available yet.");
        }
        this.template = this.getUnitRegistry().getUnitTemplateByType(config.getType());
        for (ServiceDescriptionType.ServiceDescription serviceDescription : this.template.getServiceDescriptionList()) {
            if (this.serviceStateObservableMap.containsKey(serviceDescription.getType())) continue;
            this.serviceStateObservableMap.put(serviceDescription.getType(), new MessageObservable((DataProvider)this));
        }
        block3: for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : this.serviceStateObservableMap.keySet()) {
            for (ServiceDescriptionType.ServiceDescription serviceDescription : this.template.getServiceDescriptionList()) {
                if (serviceType != serviceDescription.getType()) continue;
                continue block3;
            }
            this.serviceStateObservableMap.remove(serviceType).shutdown();
        }
        return (UnitConfigType.UnitConfig)super.applyConfigUpdate((GeneratedMessage)config);
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        if (!this.isEnabled()) {
            throw new InvalidStateException("The activation of an remote is not allowed if the referred unit is disabled!");
        }
        if (!Units.contains(this)) {
            this.logger.warn("You are using a unit remote which is not maintained by the global unit remote pool! This is extremely inefficient! Please use \"Units.getUnit(...)\" instead creating your own instances!");
        }
        super.activate();
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        this.verifyEnablingState();
        super.waitForData();
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.verifyEnablingState();
        super.waitForData(timeout, timeUnit);
    }

    public boolean isEnabled() {
        try {
            assert (this.getConfig() instanceof UnitConfigType.UnitConfig);
            return ((UnitConfigType.UnitConfig)this.getConfig()).getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED);
        }
        catch (CouldNotPerformException ex) {
            LoggerFactory.getLogger(UnitRemote.class).warn("isEnabled() was called on non initialized unit!");
            assert (false);
            return false;
        }
    }

    private void verifyEnablingState() throws FatalImplementationErrorException {
        if (!this.isEnabled()) {
            if (JPService.testMode()) {
                throw new FatalImplementationErrorException("Waiting for data of a disabled unit should be avoided!", (Object)"Calling instance");
            }
            this.logger.warn("Waiting for data of an disabled unit should be avoided! Probably this method will block forever!");
        }
    }

    public UnitTemplateType.UnitTemplate.UnitType getUnitType() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getType();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit type", ex);
        }
    }

    public UnitTemplateType.UnitTemplate getUnitTemplate() throws NotAvailableException {
        if (this.template == null) {
            throw new NotAvailableException("UnitTemplate");
        }
        return this.template;
    }

    public String getLabel() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getLabel();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public ScopeType.Scope getScope() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getScope();
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public UnitConfigType.UnitConfig getParentLocationConfig() throws NotAvailableException, InterruptedException {
        try {
            return this.getUnitRegistry().getUnitConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId());
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("LocationConfig", (Throwable)ex);
        }
    }

    @Deprecated
    public UnitConfigType.UnitConfig getLocationConfig() throws NotAvailableException {
        try {
            return this.getParentLocationConfig();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new NotAvailableException((Throwable)ex);
        }
    }

    public LocationRemote getParentLocationRemote(boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            return Units.getUnit(((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), waitForData, Units.LOCATION);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("LocationRemote", (Throwable)ex);
        }
    }

    @Deprecated
    public Future<Transform> getTransformation() throws InterruptedException {
        try {
            return Units.getRootToUnitTransformationFuture((UnitConfigType.UnitConfig)this.getConfig());
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture(Transform.class, (Exception)((Object)new NotAvailableException("UnitTransformation", (Throwable)ex)));
        }
    }

    public Future<ActionFutureType.ActionFuture> applyAction(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)actionDescription, (RSBRemote)this, ActionFutureType.ActionFuture.class);
    }

    public Future<SnapshotType.Snapshot> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((RSBRemote)this, SnapshotType.Snapshot.class);
    }

    protected ActionDescriptionType.ActionDescription.Builder updateActionDescription(ActionDescriptionType.ActionDescription.Builder actionDescription, Object serviceAttribute, ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws CouldNotPerformException {
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = actionDescription.getResourceAllocationBuilder();
        serviceStateDescription.setUnitId(this.getId());
        resourceAllocation.addResourceIds(ScopeGenerator.generateStringRep((ScopeType.Scope)this.getScope()));
        actionDescription.setDescription(actionDescription.getDescription().replace("$LABEL", this.getLabel()));
        actionDescription.setLabel(actionDescription.getLabel().replace("$LABEL", this.getLabel()));
        return Services.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)serviceAttribute, (ServiceTemplateType.ServiceTemplate.ServiceType)serviceType);
    }

    protected ActionDescriptionType.ActionDescription.Builder updateActionDescription(ActionDescriptionType.ActionDescription.Builder actionDescription, Object serviceAttribute) throws CouldNotPerformException {
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = actionDescription.getResourceAllocationBuilder();
        serviceStateDescription.setUnitId(this.getId());
        resourceAllocation.addResourceIds(ScopeGenerator.generateStringRep((ScopeType.Scope)this.getScope()));
        actionDescription.setDescription(actionDescription.getDescription().replace("$LABEL", this.getLabel()));
        actionDescription.setLabel(actionDescription.getLabel().replace("$LABEL", this.getLabel()));
        return Services.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)serviceAttribute);
    }

    public void shutdown() {
        super.shutdown();
        try {
            Registries.getUnitRegistry().removeDataObserver(this.unitRegistryObserver);
        }
        catch (NotAvailableException notAvailableException) {
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not remove unit registry observer.", (Throwable)ex), (Logger)this.logger);
        }
        for (MessageObservable serviceObservable : this.serviceStateObservableMap.values()) {
            serviceObservable.shutdown();
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionFutureType.ActionFuture.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionDescriptionType.ActionDescription.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SnapshotType.Snapshot.getDefaultInstance()));
    }
}

