/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.detector;

import com.google.protobuf.MessageOrBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotInitializedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.iface.Manageable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.MotionStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.location.LocationDataType;

public class PresenceDetector
implements Manageable<DataProvider<LocationDataType.LocationData>>,
DataProvider<PresenceStateType.PresenceState> {
    public static final long PRESENCE_TIMEOUT = JPService.testMode() ? 50L : 60000L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PresenceStateType.PresenceState.Builder presenceState = PresenceStateType.PresenceState.newBuilder();
    private final Timeout presenceTimeout;
    private final Observer<LocationDataType.LocationData> locationDataObserver;
    private DataProvider<LocationDataType.LocationData> locationDataProvider;
    private final ObservableImpl<PresenceStateType.PresenceState> presenceStateObservable = new ObservableImpl();
    private boolean active = false;

    public PresenceDetector() {
        this.presenceTimeout = new Timeout(PRESENCE_TIMEOUT){

            public void expired() {
                try {
                    if (((LocationDataType.LocationData)PresenceDetector.this.locationDataProvider.getData()).getMotionState().getValue() == MotionStateType.MotionState.State.MOTION) {
                        GlobalCachedExecutorService.submit((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PresenceDetector.this.presenceTimeout.restart();
                                }
                                catch (CouldNotPerformException ex) {
                                    ExceptionPrinter.printHistory((String)"Could not setup presence timeout!", (Throwable)ex, (Logger)PresenceDetector.this.logger);
                                }
                            }
                        });
                        return;
                    }
                    PresenceDetector.this.updatePresenceState((PresenceStateType.PresenceStateOrBuilder)PresenceStateType.PresenceState.newBuilder().setValue(PresenceStateType.PresenceState.State.ABSENT));
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify absent by timer!", (Throwable)ex), (Logger)PresenceDetector.this.logger);
                }
            }
        };
        this.locationDataObserver = (source, data) -> this.updateMotionState((MotionStateType.MotionStateOrBuilder)data.getMotionState());
    }

    public void init(DataProvider<LocationDataType.LocationData> locationDataProvider) throws InitializationException, InterruptedException {
        this.locationDataProvider = locationDataProvider;
    }

    public void init(DataProvider<LocationDataType.LocationData> locationDataProvider, long motionTimeout) throws InitializationException, InterruptedException {
        this.init(locationDataProvider);
        this.presenceTimeout.setDefaultWaitTime(motionTimeout);
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        if (this.locationDataObserver == null) {
            throw new NotInitializedException((Object)this);
        }
        this.active = true;
        this.locationDataProvider.addDataObserver(this.locationDataObserver);
        this.updateMotionState((MotionStateType.MotionStateOrBuilder)((LocationDataType.LocationData)this.locationDataProvider.getData()).getMotionState());
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.active = false;
        this.presenceTimeout.cancel();
        if (this.locationDataProvider != null) {
            this.locationDataProvider.removeDataObserver(this.locationDataObserver);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
        }
    }

    private synchronized void updatePresenceState(PresenceStateType.PresenceStateOrBuilder presenceState) throws CouldNotPerformException {
        if (presenceState.getValue() == PresenceStateType.PresenceState.State.PRESENT && this.presenceState.getLastPresence() != presenceState.getLastPresence()) {
            this.presenceTimeout.restart();
            this.presenceState.getLastPresenceBuilder().setTime(Math.max(this.presenceState.getLastPresence().getTime(), presenceState.getLastPresence().getTime()));
        }
        if (this.presenceState.getValue() == presenceState.getValue()) {
            return;
        }
        TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)presenceState, (Logger)this.logger);
        this.presenceState.setValue(presenceState.getValue());
        try {
            this.presenceStateObservable.notifyObservers((Object)this.presenceState.build());
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not update MotionState!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
    }

    private synchronized void updateMotionState(MotionStateType.MotionStateOrBuilder motionState) throws CouldNotPerformException {
        if (motionState.getValue() == MotionStateType.MotionState.State.NO_MOTION) {
            return;
        }
        if (motionState.getValue() == MotionStateType.MotionState.State.MOTION) {
            this.updatePresenceState((PresenceStateType.PresenceStateOrBuilder)PresenceStateType.PresenceState.newBuilder().setValue(PresenceStateType.PresenceState.State.PRESENT).setLastPresence(motionState.getLastMotion()));
        }
    }

    public boolean isDataAvailable() {
        return this.presenceStateObservable.isValueAvailable();
    }

    public Class<PresenceStateType.PresenceState> getDataClass() {
        return PresenceStateType.PresenceState.class;
    }

    public PresenceStateType.PresenceState getData() throws NotAvailableException {
        return (PresenceStateType.PresenceState)this.presenceStateObservable.getValue();
    }

    public CompletableFuture<PresenceStateType.PresenceState> getDataFuture() {
        return this.presenceStateObservable.getValueFuture();
    }

    public void addDataObserver(Observer<PresenceStateType.PresenceState> observer) {
        this.presenceStateObservable.addObserver(observer);
    }

    public void removeDataObserver(Observer<PresenceStateType.PresenceState> observer) {
        this.presenceStateObservable.removeObserver(observer);
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        this.presenceStateObservable.waitForValue();
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.presenceStateObservable.waitForValue(timeout, timeUnit);
    }
}

