/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import java.util.ArrayList;
import java.util.Collection;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;

public class ServiceRemoteFactoryImpl
implements ServiceRemoteFactory {
    private static ServiceRemoteFactory instance;

    private ServiceRemoteFactoryImpl() {
    }

    public static synchronized ServiceRemoteFactory getInstance() {
        if (instance == null) {
            instance = new ServiceRemoteFactoryImpl();
        }
        return instance;
    }

    @Override
    public AbstractServiceRemote newInitializedInstance(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Collection<UnitConfigType.UnitConfig> unitConfigs) throws CouldNotPerformException, InterruptedException {
        AbstractServiceRemote serviceRemote = this.newInstance(serviceType);
        serviceRemote.init(unitConfigs);
        return serviceRemote;
    }

    @Override
    public AbstractServiceRemote newInitializedInstance(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException, InterruptedException {
        AbstractServiceRemote serviceRemote = this.newInstance(serviceType);
        serviceRemote.init(unitConfig);
        return serviceRemote;
    }

    @Override
    public AbstractServiceRemote newInitializedInstanceByIds(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Collection<String> unitIDs) throws CouldNotPerformException, InterruptedException {
        Registries.getUnitRegistry().waitForData();
        ArrayList<UnitConfigType.UnitConfig> unitRemotes = new ArrayList<UnitConfigType.UnitConfig>();
        for (String unitId : unitIDs) {
            unitRemotes.add(Registries.getUnitRegistry().getUnitConfigById(unitId));
        }
        return this.newInitializedInstance(serviceType, unitRemotes);
    }

    @Override
    public AbstractServiceRemote newInitializedInstanceById(ServiceTemplateType.ServiceTemplate.ServiceType serviceType, String unitID) throws CouldNotPerformException, InterruptedException {
        Registries.getUnitRegistry().waitForData();
        return this.newInitializedInstance(serviceType, Registries.getUnitRegistry().getUnitConfigById(unitID));
    }

    public AbstractServiceRemote newInstance(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws InstantiationException {
        try {
            return ServiceRemoteFactoryImpl.instantiatServiceRemote(ServiceRemoteFactoryImpl.loadServiceRemoteClass(serviceType));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException(AbstractServiceRemote.class, serviceType.name(), (Throwable)ex);
        }
    }

    public static Class<? extends AbstractServiceRemote> loadServiceRemoteClass(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws CouldNotPerformException {
        String remoteClassName = AbstractServiceRemote.class.getPackage().getName() + "." + StringProcessor.transformUpperCaseToCamelCase((String)serviceType.name()) + "Remote";
        try {
            return ServiceRemoteFactoryImpl.class.getClassLoader().loadClass(remoteClassName);
        }
        catch (ClassNotFoundException | NullPointerException ex) {
            throw new CouldNotPerformException("Could not detect service remote class for ServiceType[" + serviceType.name() + "]!", (Throwable)ex);
        }
    }

    private static AbstractServiceRemote instantiatServiceRemote(Class<? extends AbstractServiceRemote> serviceRemoteClass) throws InstantiationException {
        try {
            AbstractServiceRemote remote = serviceRemoteClass.newInstance();
            return remote;
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new InstantiationException(serviceRemoteClass, (Throwable)ex);
        }
    }
}

