/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.collection.TemperatureStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.TemperatureStateProviderService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitTemplateType;

public class TemperatureStateServiceRemote
extends AbstractServiceRemote<TemperatureStateProviderService, TemperatureStateType.TemperatureState>
implements TemperatureStateProviderServiceCollection {
    public TemperatureStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.TEMPERATURE_STATE_SERVICE, TemperatureStateType.TemperatureState.class);
    }

    public Collection<TemperatureStateProviderService> getTemperatureStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected TemperatureStateType.TemperatureState computeServiceState() throws CouldNotPerformException {
        return this.getTemperatureState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public TemperatureStateType.TemperatureState getTemperatureState() throws NotAvailableException {
        return (TemperatureStateType.TemperatureState)this.getServiceState();
    }

    public TemperatureStateType.TemperatureState getTemperatureState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        Double average = 0.0;
        Collection temperatureStateProviderServices = this.getServices(unitType);
        int amount = temperatureStateProviderServices.size();
        long timestamp = 0L;
        for (TemperatureStateProviderService service : temperatureStateProviderServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --amount;
                continue;
            }
            average = average + service.getTemperatureState().getTemperature();
            timestamp = Math.max(timestamp, service.getTemperatureState().getTimestamp().getTime());
        }
        average = average / (double)amount;
        return ((TemperatureStateType.TemperatureState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)TemperatureStateType.TemperatureState.newBuilder().setTemperature(average.doubleValue()), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

