/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.trigger;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.MessageOrBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.remote.trigger.GenericBCOTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;

public class GenericValueDualBoundaryBCOTrigger<UR extends AbstractUnitRemote, DT extends GeneratedMessage>
extends AbstractTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericBCOTrigger.class);
    private final UR unitRemote;
    private final ServiceTemplateType.ServiceTemplate.ServiceType serviceType;
    private final double upperBoundary;
    private final double lowerBoundary;
    private final Observer<DT> dataObserver;
    private final Observer<Remote.ConnectionState> connectionObserver;
    private final TriggerOperation triggerOperation;
    private final String specificValueCall;
    private boolean active = false;

    public GenericValueDualBoundaryBCOTrigger(UR unitRemote, double upperBoundary, double lowerBoundary, TriggerOperation triggerOperation, ServiceTemplateType.ServiceTemplate.ServiceType serviceType, String specificValueCall) throws InstantiationException {
        if (upperBoundary < lowerBoundary) {
            throw new InstantiationException(((Object)((Object)this)).getClass(), new Throwable("upperBoundary below lowerBoundary"));
        }
        this.unitRemote = unitRemote;
        this.serviceType = serviceType;
        this.upperBoundary = upperBoundary;
        this.lowerBoundary = lowerBoundary;
        this.triggerOperation = triggerOperation;
        this.specificValueCall = specificValueCall;
        this.dataObserver = (source, data) -> this.verifyCondition(data);
        this.connectionObserver = (source, data) -> {
            if (data.equals((Object)Remote.ConnectionState.CONNECTED)) {
                this.verifyCondition(unitRemote.getData());
            } else {
                this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
            }
        };
    }

    private void verifyCondition(DT data) {
        try {
            Object serviceState = Services.invokeProviderServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)this.serviceType, data, (Object[])new Object[0]);
            Method method = serviceState.getClass().getMethod(this.specificValueCall, new Class[0]);
            double value = (Double)method.invoke(serviceState, new Object[0]);
            if (null != this.triggerOperation) {
                switch (this.triggerOperation) {
                    case HIGH_ACTIVE: {
                        if (value >= this.upperBoundary) {
                            this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
                            break;
                        }
                        if (!(value < this.lowerBoundary)) break;
                        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
                        break;
                    }
                    case LOW_ACTIVE: {
                        if (value > this.upperBoundary) {
                            this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
                            break;
                        }
                        if (!(value <= this.lowerBoundary)) break;
                        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
                        break;
                    }
                    case INSIDE_ACTIVE: {
                        if (this.lowerBoundary <= value && value <= this.upperBoundary) {
                            this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
                            break;
                        }
                        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
                        break;
                    }
                    case OUTSIDE_ACTIVE: {
                        if (value < this.lowerBoundary || this.upperBoundary < value) {
                            this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
                            break;
                        }
                        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
                    }
                }
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not verify condition " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
        catch (NoSuchMethodException ex) {
            ExceptionPrinter.printHistory((String)("Method not known " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
        catch (SecurityException ex) {
            ExceptionPrinter.printHistory((String)("Security Exception " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
        catch (IllegalAccessException ex) {
            ExceptionPrinter.printHistory((String)("Illegal Access Exception " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
        catch (IllegalArgumentException ex) {
            ExceptionPrinter.printHistory((String)("Illegal Argument Exception " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
        catch (InvocationTargetException ex) {
            ExceptionPrinter.printHistory((String)("Could not invoke method " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        ((AbstractUnitRemote)((Object)this.unitRemote)).addDataObserver(this.dataObserver);
        this.unitRemote.addConnectionStateObserver(this.connectionObserver);
        this.active = true;
        this.verifyCondition(this.unitRemote.getData());
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        ((AbstractUnitRemote)((Object)this.unitRemote)).removeDataObserver(this.dataObserver);
        this.unitRemote.removeConnectionStateObserver(this.connectionObserver);
        this.active = false;
        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
    }

    public boolean isActive() {
        return this.active;
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + (Object)((Object)this)), (Throwable)ex, (Logger)LOGGER);
        }
        super.shutdown();
    }

    public static enum TriggerOperation {
        HIGH_ACTIVE,
        LOW_ACTIVE,
        INSIDE_ACTIVE,
        OUTSIDE_ACTIVE;

    }
}

