/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.ColorableLight;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.extension.rst.processing.MetaConfigPool;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.processing.VariableProvider;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceConfigType;
import rst.domotic.service.ServiceTemplateConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateConfigType;
import rst.domotic.unit.dal.ColorableLightDataType;
import rst.domotic.unit.device.DeviceClassType;
import rst.rsb.ScopeType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class ColorableLightRemote
extends AbstractUnitRemote<ColorableLightDataType.ColorableLightData>
implements ColorableLight {
    private ColorType.Color neutralWhite;

    public ColorableLightRemote() {
        super(ColorableLightDataType.ColorableLightData.class);
    }

    @Override
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        this.updateNeutralWhiteValue(config);
        return super.applyConfigUpdate(config);
    }

    public void updateNeutralWhiteValue(UnitConfigType.UnitConfig config) throws InterruptedException {
        try {
            MetaConfigPool configPool = new MetaConfigPool();
            configPool.register((VariableProvider)new MetaConfigVariableProvider("UnitConfig", config.getMetaConfig()));
            ServiceConfigType.ServiceConfig colorStateServiceConfig = null;
            for (ServiceConfigType.ServiceConfig serviceConfig : config.getServiceConfigList()) {
                if (serviceConfig.getServiceDescription().getType() != ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE) continue;
                colorStateServiceConfig = serviceConfig;
            }
            if (colorStateServiceConfig != null) {
                configPool.register((VariableProvider)new MetaConfigVariableProvider("ServiceConfig", colorStateServiceConfig.getMetaConfig()));
            }
            UnitConfigType.UnitConfig deviceUnitConfig = Registries.getUnitRegistry((boolean)true).getUnitConfigById(config.getUnitHostId());
            configPool.register((VariableProvider)new MetaConfigVariableProvider("DeviceUnitConfig", deviceUnitConfig.getMetaConfig()));
            Registries.getDeviceRegistry().waitForData();
            DeviceClassType.DeviceClass deviceClass = Registries.getDeviceRegistry().getDeviceClassById(deviceUnitConfig.getDeviceConfig().getDeviceClassId());
            configPool.register((VariableProvider)new MetaConfigVariableProvider("DeviceClass", deviceClass.getMetaConfig()));
            ServiceTemplateConfigType.ServiceTemplateConfig colorStateServiceTemplateConfig = null;
            for (UnitTemplateConfigType.UnitTemplateConfig unitTemplateConfig : deviceClass.getUnitTemplateConfigList()) {
                if (!unitTemplateConfig.getId().equals(config.getUnitTemplateConfigId())) continue;
                for (ServiceTemplateConfigType.ServiceTemplateConfig serviceTempalteConfig : unitTemplateConfig.getServiceTemplateConfigList()) {
                    if (serviceTempalteConfig.getServiceType() != ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE) continue;
                    colorStateServiceTemplateConfig = serviceTempalteConfig;
                }
            }
            if (colorStateServiceTemplateConfig != null) {
                configPool.register((VariableProvider)new MetaConfigVariableProvider("ServiceTemplateConfig", colorStateServiceTemplateConfig.getMetaConfig()));
            }
            try {
                String neutralWhiteString = configPool.getValue("NEUTRAL_WHITE");
                try {
                    String[] split = neutralWhiteString.replace(" ", "").split(",");
                    if (split.length != 3) {
                        throw new CouldNotPerformException("NeutralWhite for [" + ScopeGenerator.generateStringRep((ScopeType.Scope)config.getScope()) + "] has the wrong number of parameters!");
                    }
                    double hue = Double.parseDouble(split[0]);
                    double saturation = Double.parseDouble(split[1]);
                    double brightness = Double.parseDouble(split[2]);
                    HSBColorType.HSBColor hsbColor = HSBColorType.HSBColor.newBuilder().setHue(hue).setSaturation(saturation).setBrightness(brightness).build();
                    this.neutralWhite = ColorType.Color.newBuilder().setType(ColorType.Color.Type.HSB).setHsbColor(hsbColor).build();
                }
                catch (CouldNotPerformException ex) {
                    this.logger.warn("Could not parse [" + neutralWhiteString + "] as neutral white! Please define as <h, s, b>", (Throwable)ex);
                    throw new NotAvailableException("NeutralWhite");
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Could not parse [" + neutralWhiteString + "] as doubles and thus as NeutralWhite!", (Throwable)ex);
                    throw new NotAvailableException("NeutralWhite");
                }
            }
            catch (NotAvailableException ex) {
                this.neutralWhite = ColorType.Color.newBuilder().setType(ColorType.Color.Type.RGB).setRgbColor(DEFAULT_NEUTRAL_WHITE).build();
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not find NeutralWhite!", (Throwable)ex), (Logger)this.logger);
        }
    }

    public Future<ActionFutureType.ActionFuture> setColorState(ColorStateType.ColorState colorState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)colorState).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting colorState.", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setNeutralWhite() throws CouldNotPerformException {
        return this.setColor(this.neutralWhite);
    }

    public Future<ActionFutureType.ActionFuture> setBrightnessState(BrightnessStateType.BrightnessState brightnessState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)brightnessState).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting brightnessState.", (Throwable)ex);
        }
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((ColorableLightDataType.ColorableLightData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setPowerState(PowerStateType.PowerState powerState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)powerState).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting powerState.", (Throwable)ex);
        }
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        try {
            return ((ColorableLightDataType.ColorableLightData)this.getData()).getColorState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("ColorState", (Throwable)ex);
        }
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        try {
            return ((ColorableLightDataType.ColorableLightData)this.getData()).getBrightnessState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("BrightnessState", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorableLightDataType.ColorableLightData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorStateType.ColorState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorType.Color.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)HSBColorType.HSBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)RGBColorType.RGBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
    }
}

