/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.service.collection.BlindStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.BlindStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.unit.UnitTemplateType;

public class BlindStateServiceRemote
extends AbstractServiceRemote<BlindStateOperationService, BlindStateType.BlindState>
implements BlindStateOperationServiceCollection {
    public BlindStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.BLIND_STATE_SERVICE, BlindStateType.BlindState.class);
    }

    public Collection<BlindStateOperationService> getBlindStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected BlindStateType.BlindState computeServiceState() throws CouldNotPerformException {
        return this.getBlindState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public BlindStateType.BlindState getBlindState() throws NotAvailableException {
        return (BlindStateType.BlindState)this.getData();
    }

    public BlindStateType.BlindState getBlindState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        int serviceNumber = this.getBlindStateOperationServices().size();
        int stop = 0;
        int down = 0;
        int up = 0;
        long timestamp = 0L;
        float openingRatioAverage = 0.0f;
        for (BlindStateOperationService service : this.getBlindStateOperationServices()) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            switch (service.getBlindState().getMovementState()) {
                case DOWN: {
                    ++down;
                    break;
                }
                case STOP: {
                    ++stop;
                    break;
                }
                case UP: {
                    ++up;
                }
            }
            openingRatioAverage = (float)((double)openingRatioAverage + service.getBlindState().getOpeningRatio());
            timestamp = Math.max(timestamp, service.getBlindState().getTimestamp().getTime());
        }
        BlindStateType.BlindState.MovementState mostOccurences = stop >= up && stop >= down ? BlindStateType.BlindState.MovementState.STOP : (up >= stop && up >= down ? BlindStateType.BlindState.MovementState.UP : BlindStateType.BlindState.MovementState.DOWN);
        return ((BlindStateType.BlindState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)BlindStateType.BlindState.newBuilder().setMovementState(mostOccurences).setOpeningRatio((double)(openingRatioAverage /= (float)serviceNumber)), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }

    public Future<ActionFutureType.ActionFuture> setBlindState(BlindStateType.BlindState blindState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)blindState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set blindState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setBlindState(BlindStateType.BlindState blindState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        serviceStateDescription.setUnitType(unitType);
        try {
            return this.applyAction(Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)blindState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set blindState", (Throwable)ex);
        }
    }
}

