/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.service.collection.StandbyStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.StandbyStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.unit.UnitTemplateType;

public class StandbyStateServiceRemote
extends AbstractServiceRemote<StandbyStateOperationService, StandbyStateType.StandbyState>
implements StandbyStateOperationServiceCollection {
    public StandbyStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.STANDBY_STATE_SERVICE, StandbyStateType.StandbyState.class);
    }

    public Future<ActionFutureType.ActionFuture> setStandbyState(StandbyStateType.StandbyState standbyState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)standbyState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set standbyState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setStandbyState(StandbyStateType.StandbyState standbyState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        serviceStateDescription.setUnitType(unitType);
        try {
            return this.applyAction(Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Object)standbyState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set standbyState", (Throwable)ex);
        }
    }

    public Collection<StandbyStateOperationService> getStandbyStateOperationServices() {
        return this.getServices();
    }

    @Override
    protected StandbyStateType.StandbyState computeServiceState() throws CouldNotPerformException {
        return this.getStandbyState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public StandbyStateType.StandbyState getStandbyState() throws NotAvailableException {
        return (StandbyStateType.StandbyState)this.getServiceState();
    }

    public StandbyStateType.StandbyState getStandbyState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        StandbyStateType.StandbyState.State standbyValue = StandbyStateType.StandbyState.State.STANDBY;
        long timestamp = 0L;
        for (StandbyStateOperationService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) continue;
            if (service.getStandbyState().getValue() == StandbyStateType.StandbyState.State.RUNNING) {
                standbyValue = StandbyStateType.StandbyState.State.RUNNING;
            }
            timestamp = Math.max(timestamp, service.getStandbyState().getTimestamp().getTime());
        }
        return ((StandbyStateType.StandbyState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)StandbyStateType.StandbyState.newBuilder().setValue(standbyValue), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

