/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.action;

import de.citec.csra.allocation.cli.AllocatableResource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.schedule.GlobalScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.RSBException;
import rst.calendar.DateTimeType;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;

public class ActionRescheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionRescheduler.class);
    private final long periodSecs;
    private final Map<String, AllocatableResource> allocationMap = new HashMap<String, AllocatableResource>();
    private final RescheduleOption rescheduleOption;
    private ScheduledFuture<?> rescheduleFuture;
    private boolean started;

    public ActionRescheduler(RescheduleOption rescheduleOption, long periodSecs) {
        this.rescheduleOption = rescheduleOption;
        this.periodSecs = periodSecs;
        this.started = false;
    }

    public void startActionRescheduleing(ActionFutureType.ActionFuture.Builder actionFuture) {
        this.started = true;
        this.addRescheduleAction(actionFuture);
        if (this.rescheduleFuture == null && this.rescheduleOption == RescheduleOption.EXTEND) {
            this.startExtending();
        }
    }

    public void addRescheduleAction(ActionFutureType.ActionFuture.Builder actionFuture) {
        if (actionFuture.getActionDescriptionCount() != 0 && actionFuture.getActionDescription(0).getMultiResourceAllocationStrategy().getStrategy() == MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE) {
            for (ActionDescriptionType.ActionDescription.Builder actionDescription : actionFuture.getActionDescriptionBuilderList()) {
                try {
                    AllocatableResource allocatableResource = new AllocatableResource(actionDescription.getResourceAllocation());
                    allocatableResource.startup();
                    allocatableResource.getRemote().addSchedulerListener(allocation -> {
                        switch (allocation.getState()) {
                            case REJECTED: {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException ex) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            case ABORTED: 
                            case RELEASED: 
                            case CANCELLED: {
                                this.reApplyAction(actionDescription, allocation);
                                break;
                            }
                        }
                    });
                    switch (allocatableResource.getRemote().getCurrentState()) {
                        case REJECTED: 
                        case ABORTED: 
                        case RELEASED: 
                        case CANCELLED: {
                            allocatableResource.getRemote().removeAllSchedulerListeners();
                            this.reApplyAction(actionDescription, actionDescription.getResourceAllocation());
                            break;
                        }
                        default: {
                            this.allocationMap.put(actionDescription.getResourceAllocation().getId(), allocatableResource);
                            break;
                        }
                    }
                }
                catch (RSBException ex) {
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                }
            }
        }
    }

    private void reApplyAction(ActionDescriptionType.ActionDescription.Builder actionDescription, ResourceAllocationType.ResourceAllocation allocation) {
        if (!this.started) {
            return;
        }
        this.allocationMap.remove(allocation.getId());
        if (this.rescheduleOption == RescheduleOption.EXTEND) {
            long anHourFromNow = System.currentTimeMillis() + 3600000L;
            DateTimeType.DateTime dateTime = DateTimeType.DateTime.newBuilder().setDateTimeType(DateTimeType.DateTime.Type.FLOATING).setMillisecondsSinceEpoch(anHourFromNow).build();
            actionDescription.setExecutionValidity(dateTime);
        }
        if (actionDescription.getExecutionValidity().getMillisecondsSinceEpoch() > System.currentTimeMillis()) {
            ActionDescriptionProcessor.updateResourceAllocationId((ActionDescriptionType.ActionDescription.Builder)actionDescription);
            ActionDescriptionProcessor.updateResourceAllocationSlot((ActionDescriptionType.ActionDescription.Builder)actionDescription);
            try {
                UnitRemote<?> unit = Units.getUnit(actionDescription.getServiceStateDescription().getUnitId(), true);
                this.addRescheduleAction(((ActionFutureType.ActionFuture)unit.applyAction(actionDescription.build()).get(actionDescription.getExecutionTimePeriod(), TimeUnit.SECONDS)).toBuilder());
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            }
            catch (CancellationException | ExecutionException | CouldNotPerformException ex) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.reApplyAction(actionDescription, allocation);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    private void startExtending() {
        if (this.rescheduleOption == RescheduleOption.EXTEND) {
            try {
                this.rescheduleFuture = GlobalScheduledExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (AllocatableResource allocatableResource : ActionRescheduler.this.allocationMap.values()) {
                            if (allocatableResource.getRemote().getRemainingTime() >= ActionRescheduler.this.periodSecs / 2L * 1000L * 1000L) continue;
                            try {
                                allocatableResource.getRemote().extend(ActionRescheduler.this.periodSecs, TimeUnit.SECONDS);
                            }
                            catch (RSBException ex) {
                                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not extend resource allocation", (Throwable)ex), (Logger)LOGGER);
                                java.util.logging.Logger.getLogger(ActionRescheduler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }, (long)0L, (long)(this.periodSecs / 3L), (TimeUnit)TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException | NotAvailableException ex) {
                new FatalImplementationErrorException("Scheduling extension thread failed!", (Object)this, ex);
            }
            catch (RejectedExecutionException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            }
        }
    }

    public void stopExecution() {
        this.started = false;
        if (this.rescheduleFuture != null) {
            this.rescheduleFuture.cancel(true);
            this.rescheduleFuture = null;
        }
        for (AllocatableResource allocatableResource : this.allocationMap.values()) {
            allocatableResource.getRemote().removeAllSchedulerListeners();
            try {
                allocatableResource.shutdown();
            }
            catch (RSBException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not shutdown allocatableResource", (Throwable)ex), (Logger)LOGGER);
            }
        }
        this.allocationMap.clear();
    }

    public static enum RescheduleOption {
        EXPIRE,
        EXTEND;

    }
}

