/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.collection.SmokeAlarmStateProviderServiceCollection;
import org.openbase.bco.dal.lib.layer.service.provider.SmokeAlarmStateProviderService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.AlarmStateType;
import rst.domotic.unit.UnitTemplateType;

public class SmokeAlarmStateServiceRemote
extends AbstractServiceRemote<SmokeAlarmStateProviderService, AlarmStateType.AlarmState>
implements SmokeAlarmStateProviderServiceCollection {
    public SmokeAlarmStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.SMOKE_ALARM_STATE_SERVICE, AlarmStateType.AlarmState.class);
    }

    public Collection<SmokeAlarmStateProviderService> getSmokeAlarmStateProviderServices() {
        return this.getServices();
    }

    @Override
    protected AlarmStateType.AlarmState computeServiceState() throws CouldNotPerformException {
        return this.getSmokeAlarmState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public AlarmStateType.AlarmState getSmokeAlarmState() throws NotAvailableException {
        return (AlarmStateType.AlarmState)this.getServiceState();
    }

    public AlarmStateType.AlarmState getSmokeAlarmState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        AlarmStateType.AlarmState.State alarmValue = AlarmStateType.AlarmState.State.NO_ALARM;
        long timestamp = 0L;
        for (SmokeAlarmStateProviderService service : this.getServices(unitType)) {
            if (!((UnitRemote)service).isDataAvailable()) continue;
            if (service.getSmokeAlarmState().getValue() == AlarmStateType.AlarmState.State.ALARM) {
                alarmValue = AlarmStateType.AlarmState.State.ALARM;
            }
            timestamp = Math.max(timestamp, service.getSmokeAlarmState().getTimestamp().getTime());
        }
        return ((AlarmStateType.AlarmState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)AlarmStateType.AlarmState.newBuilder().setValue(alarmValue), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

