/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.lib.layer.service.collection.EmphasisStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.EmphasisStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.EmphasisStateType;
import rst.domotic.unit.UnitTemplateType;

public class EmphasisStateServiceRemote
extends AbstractServiceRemote<EmphasisStateOperationService, EmphasisStateType.EmphasisState>
implements EmphasisStateOperationServiceCollection {
    public EmphasisStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.EMPHASIS_STATE_SERVICE, EmphasisStateType.EmphasisState.class);
    }

    public Collection<EmphasisStateOperationService> getEmphasisStateOperationServices() throws CouldNotPerformException {
        return this.getServices();
    }

    @Override
    protected EmphasisStateType.EmphasisState computeServiceState() throws CouldNotPerformException {
        return this.getEmphasisState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public Future<ActionFutureType.ActionFuture> setEmphasisState(EmphasisStateType.EmphasisState emphasisState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(Services.updateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Message)emphasisState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set brightnessState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setEmphasisState(EmphasisStateType.EmphasisState emphasisState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        serviceStateDescription.setUnitType(unitType);
        try {
            return this.applyAction(Services.updateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Message)emphasisState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set brightnessState", (Throwable)ex);
        }
    }

    public EmphasisStateType.EmphasisState getEmphasisState() throws NotAvailableException {
        return (EmphasisStateType.EmphasisState)this.getData();
    }

    public EmphasisStateType.EmphasisState getEmphasisState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        Collection emphasisStateOperationServices = this.getServices(unitType);
        int serviceNumber = emphasisStateOperationServices.size();
        Double averageComfort = 0.0;
        Double averageEnergy = 0.0;
        Double averageSecurity = 0.0;
        long timestamp = 0L;
        for (EmphasisStateOperationService service : emphasisStateOperationServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            averageComfort = averageComfort + service.getEmphasisState().getComfort();
            averageEnergy = averageEnergy + service.getEmphasisState().getEnergy();
            averageSecurity = averageSecurity + service.getEmphasisState().getSecurity();
            timestamp = Math.max(timestamp, service.getEmphasisState().getTimestamp().getTime());
        }
        averageComfort = averageComfort / (double)serviceNumber;
        averageEnergy = averageEnergy / (double)serviceNumber;
        averageSecurity = averageSecurity / (double)serviceNumber;
        return ((EmphasisStateType.EmphasisState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)EmphasisStateType.EmphasisState.newBuilder().setComfort(averageComfort.doubleValue()).setEnergy(averageEnergy.doubleValue()).setSecurity(averageSecurity.doubleValue()), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

