/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public class UnitRemoteFactoryImpl
implements UnitRemoteFactory {
    private static UnitRemoteFactory instance;

    private UnitRemoteFactoryImpl() {
    }

    public static synchronized UnitRemoteFactory getInstance() {
        if (instance == null) {
            instance = new UnitRemoteFactoryImpl();
        }
        return instance;
    }

    @Deprecated
    public AbstractUnitRemote createUnitRemote(UnitConfigType.UnitConfig config) throws CouldNotPerformException {
        return (AbstractUnitRemote)this.newInstance(config);
    }

    @Deprecated
    public AbstractUnitRemote createAndInitUnitRemote(UnitConfigType.UnitConfig config) throws CouldNotPerformException {
        try {
            return (AbstractUnitRemote)this.newInitializedInstance(config);
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("FATAL ERROR: Interrupted Exception was catched!!! Deprecated API in use!", (Throwable)ex);
        }
    }

    public static Class<? extends AbstractUnitRemote> loadUnitRemoteClass(UnitConfigType.UnitConfig config) throws CouldNotPerformException {
        return UnitRemoteFactoryImpl.loadUnitRemoteClass(config.getType());
    }

    public static Class<? extends AbstractUnitRemote> loadUnitRemoteClass(UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        try {
            String remoteClassName = null;
            if (UnitConfigProcessor.isBaseUnit((UnitTemplateType.UnitTemplate.UnitType)unitType)) {
                remoteClassName = AbstractUnitRemote.class.getPackage().getName() + "." + unitType.name().toLowerCase().replaceAll("_", "") + "." + StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Remote";
            } else if (UnitConfigProcessor.isDalUnit((UnitTemplateType.UnitTemplate.UnitType)unitType)) {
                remoteClassName = AbstractUnitRemote.class.getPackage().getName() + "." + StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Remote";
            } else {
                throw new EnumNotSupportedException((Enum)unitType, UnitRemoteFactoryImpl.class);
            }
            return UnitRemoteFactoryImpl.class.getClassLoader().loadClass(remoteClassName);
        }
        catch (ClassNotFoundException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not detect unit remote class for UnitType[" + unitType.name() + "]!", ex);
        }
    }

    @Override
    public UnitRemote newInstance(UnitConfigType.UnitConfig config) throws InstantiationException {
        try {
            return this.newInstance(UnitRemoteFactoryImpl.loadUnitRemoteClass(config));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)"Could not create unit remote!", (Throwable)ex);
        }
    }

    @Override
    public <R extends AbstractUnitRemote> R newInstance(Class<R> unitRemoteClass) throws InstantiationException {
        try {
            return (R)((Object)((AbstractUnitRemote)((Object)unitRemoteClass.newInstance())));
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new InstantiationException((Object)("Could not instantiate unit remote out of Class[" + unitRemoteClass.getName() + "]"), (Throwable)ex);
        }
    }

    @Override
    public UnitRemote newInstance(UnitTemplateType.UnitTemplate.UnitType type) throws InstantiationException {
        try {
            return this.newInstance(UnitRemoteFactoryImpl.loadUnitRemoteClass(type));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)"Could not create unit remote!", (Throwable)ex);
        }
    }

    @Override
    public UnitRemote newInstance(String unitId, long timeout, TimeUnit timeUnit) throws InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigById(unitId));
    }

    @Override
    public UnitRemote newInstance(ScopeType.Scope scope, long timeout, TimeUnit timeUnit) throws InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigByScope(scope));
    }

    @Override
    public UnitRemote newInitializedInstance(UnitConfigType.UnitConfig config) throws InitializationException, InstantiationException, InterruptedException {
        UnitRemote unitRemote = this.newInstance(config);
        unitRemote.init((Object)config);
        return unitRemote;
    }

    @Override
    public UnitRemote newInitializedInstance(ScopeType.Scope scope, UnitTemplateType.UnitTemplate.UnitType type) throws InitializationException, InstantiationException, InterruptedException {
        UnitRemote unitRemote = this.newInstance(type);
        unitRemote.init(scope);
        return unitRemote;
    }

    @Override
    public <R extends AbstractUnitRemote> R newInitializedInstance(ScopeType.Scope scope, Class<R> unitRemoteClass) throws InitializationException, InstantiationException, InterruptedException {
        R unitRemote = this.newInstance(unitRemoteClass);
        ((AbstractUnitRemote)((Object)unitRemote)).init(scope);
        return unitRemote;
    }

    @Override
    public UnitRemote newInitializedInstance(ScopeType.Scope scope, long timeout, TimeUnit timeUnit) throws InitializationException, InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInitializedInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigByScope(scope));
    }

    @Override
    public UnitRemote newInitializedInstance(String unitId, long timeout, TimeUnit timeUnit) throws InitializationException, InstantiationException, CouldNotPerformException, InterruptedException {
        CachedUnitRegistryRemote.waitForData((long)timeout, (TimeUnit)timeUnit);
        return this.newInitializedInstance(CachedUnitRegistryRemote.getRegistry().getUnitConfigById(unitId));
    }
}

