/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit.util;

import com.google.protobuf.GeneratedMessage;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.util.StateComparator;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitStateAwaiter<D extends GeneratedMessage, UR extends UnitRemote<D>> {
    protected final Logger logger = LoggerFactory.getLogger(UnitStateAwaiter.class);
    private final SyncObject stateMonitor = new SyncObject("StateMonitor");
    private final Observer<D> dataObserver;
    private final UR unitRemote;

    public UnitStateAwaiter(UR unitRemote) {
        this.unitRemote = unitRemote;
        this.dataObserver = (source, data) -> {
            SyncObject syncObject = this.stateMonitor;
            synchronized (syncObject) {
                this.stateMonitor.notifyAll();
            }
        };
        this.unitRemote.addDataObserver(this.dataObserver);
    }

    public void waitForState(StateComparator<D> stateComparator) throws InterruptedException {
        block2: {
            try {
                this.waitForState(stateComparator, 0L);
            }
            catch (TimeoutException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(StateComparator<D> stateComparator, long timeout) throws InterruptedException, TimeoutException {
        SyncObject syncObject = this.stateMonitor;
        synchronized (syncObject) {
            long timeWaited = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (stateComparator.equalState((GeneratedMessage)this.unitRemote.getData())) {
                        return;
                    }
                    this.logger.info("State not yet reached. Waiting...");
                }
                catch (NotAvailableException ex) {
                    this.logger.info("Waiting because unit data not available!");
                }
                long currentTime = System.currentTimeMillis();
                this.stateMonitor.wait(timeout);
                this.logger.info("Woke up! Time waited " + (timeWaited += System.currentTimeMillis() - currentTime) + "ms");
                if (timeout == 0L || timeWaited <= timeout) continue;
                throw new TimeoutException("Timeout expired!");
            }
        }
    }
}

