/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.processing;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.dal.lib.layer.service.operation.PowerStateOperationService;
import org.openbase.bco.dal.lib.layer.service.operation.StandbyStateOperationService;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Initializable;
import org.openbase.jul.iface.Snapshotable;
import org.openbase.jul.iface.provider.LabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.action.SnapshotType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitTemplateType;

public class StandbyController<C extends StandbyStateOperationService & Snapshotable<SnapshotType.Snapshot> & PowerStateOperationService>
implements Initializable<C> {
    public static final long RECORD_SNAPSHOT_TIMEOUT = 60L;
    public static final long RESTORE_SNAPSHOT_TIMEOUT = 15L;
    private SnapshotType.Snapshot snapshot;
    private C controller;
    private Logger logger;

    public void init(C controller) throws InitializationException, InterruptedException {
        this.controller = controller;
        this.logger = LoggerFactory.getLogger(controller.getClass());
    }

    public void standby() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Standby " + ((LabelProvider)this.controller).getLabel() + "...");
        try {
            try {
                this.logger.debug("Create snapshot of " + ((LabelProvider)this.controller).getLabel() + " state.");
                this.snapshot = (SnapshotType.Snapshot)((Snapshotable)this.controller).recordSnapshot().get(60L, TimeUnit.SECONDS);
                ArrayList<ServiceStateDescriptionType.ServiceStateDescription> serviceStateDescriptionList = new ArrayList<ServiceStateDescriptionType.ServiceStateDescription>();
                for (ServiceStateDescriptionType.ServiceStateDescription serviceStateDescription : this.snapshot.getServiceStateDescriptionList()) {
                    if (serviceStateDescription.getServiceAttribute().toLowerCase().contains("off")) {
                        this.logger.debug("ignore " + serviceStateDescription.getUnitId() + " because unit is off.");
                        continue;
                    }
                    if (serviceStateDescription.getServiceAttribute().toLowerCase().contains("brightness: 0.0")) {
                        this.logger.debug("ignore " + serviceStateDescription.getUnitId() + " because brightness is 0.");
                        continue;
                    }
                    if (UnitConfigProcessor.isBaseUnit((UnitTemplateType.UnitTemplate.UnitType)serviceStateDescription.getUnitType())) {
                        this.logger.debug("ignore " + serviceStateDescription.getUnitId() + " because is a base unit.");
                        continue;
                    }
                    if (serviceStateDescription.getUnitType().equals((Object)UnitTemplateType.UnitTemplate.UnitType.ROLLER_SHUTTER)) {
                        this.logger.debug("ignore " + serviceStateDescription.getUnitId() + " because reconstructing roller shutter states are to dangerous.");
                        continue;
                    }
                    if (!(serviceStateDescription.getServiceType().equals((Object)ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE) || serviceStateDescription.getServiceType().equals((Object)ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE) || serviceStateDescription.getServiceType().equals((Object)ServiceTemplateType.ServiceTemplate.ServiceType.COLOR_STATE_SERVICE))) {
                        this.logger.debug("ignore " + serviceStateDescription.getUnitId() + " because this type is not supported by " + this);
                        continue;
                    }
                    serviceStateDescriptionList.add(serviceStateDescription);
                }
                this.snapshot = this.snapshot.toBuilder().clearServiceStateDescription().addAllServiceStateDescription(serviceStateDescriptionList).build();
            }
            catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not create snapshot!", (Throwable)ex, (Logger)this.logger);
            }
            this.logger.info("Switch off all devices in the " + ((LabelProvider)this.controller).getLabel());
            ((PowerStateOperationService)this.controller).setPowerState(PowerStateType.PowerState.State.OFF);
            this.logger.info(((LabelProvider)this.controller).getLabel() + " is now standby.");
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Standby failed!", (Throwable)ex);
        }
    }

    public void wakeup() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Wake up " + ((LabelProvider)this.controller).getLabel() + "...");
        if (this.snapshot == null) {
            this.logger.debug("skip wake up because no snapshot information available!");
            return;
        }
        Future restoreSnapshotFuture = null;
        try {
            this.logger.debug("restore snapshot: " + this.snapshot);
            restoreSnapshotFuture = ((Snapshotable)this.controller).restoreSnapshot((Object)this.snapshot);
            restoreSnapshotFuture.get(15L, TimeUnit.SECONDS);
            this.snapshot = null;
        }
        catch (ExecutionException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("WakeUp failed!", ex);
        }
        catch (TimeoutException ex) {
            if (restoreSnapshotFuture != null) {
                restoreSnapshotFuture.cancel(true);
            }
            throw new CouldNotPerformException("WakeUp took more than 15 seconds", (Throwable)ex);
        }
    }
}

