/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.service;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.lib.layer.service.collection.BrightnessStateOperationServiceCollection;
import org.openbase.bco.dal.lib.layer.service.operation.BrightnessStateOperationService;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.slf4j.Logger;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.unit.UnitTemplateType;

public class BrightnessStateServiceRemote
extends AbstractServiceRemote<BrightnessStateOperationService, BrightnessStateType.BrightnessState>
implements BrightnessStateOperationServiceCollection {
    public BrightnessStateServiceRemote() {
        super(ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE, BrightnessStateType.BrightnessState.class);
    }

    public Collection<BrightnessStateOperationService> getBrightnessStateOperationServices() throws CouldNotPerformException {
        return this.getServices();
    }

    public Future<ActionFutureType.ActionFuture> setBrightnessState(BrightnessStateType.BrightnessState brightnessState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(Services.updateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Message)brightnessState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set brightnessState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setBrightnessState(BrightnessStateType.BrightnessState brightnessState, UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescription.getServiceStateDescriptionBuilder();
        serviceStateDescription.setUnitType(unitType);
        try {
            return this.applyAction(Services.updateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescription, (Message)brightnessState, (ServiceTemplateType.ServiceTemplate.ServiceType)this.getServiceType()).build());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not set brightnessState", (Throwable)ex);
        }
    }

    @Override
    protected BrightnessStateType.BrightnessState computeServiceState() throws CouldNotPerformException {
        return this.getBrightnessState(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        return (BrightnessStateType.BrightnessState)this.getData();
    }

    public BrightnessStateType.BrightnessState getBrightnessState(UnitTemplateType.UnitTemplate.UnitType unitType) throws NotAvailableException {
        Collection brightnessStateOperationServices = this.getServices(unitType);
        int serviceNumber = brightnessStateOperationServices.size();
        Double average = 0.0;
        long timestamp = 0L;
        for (BrightnessStateOperationService service : brightnessStateOperationServices) {
            if (!((UnitRemote)service).isDataAvailable()) {
                --serviceNumber;
                continue;
            }
            average = average + service.getBrightnessState().getBrightness();
            timestamp = Math.max(timestamp, service.getBrightnessState().getTimestamp().getTime());
        }
        average = average / (double)serviceNumber;
        return ((BrightnessStateType.BrightnessState.Builder)TimestampProcessor.updateTimestamp((long)timestamp, (MessageOrBuilder)BrightnessStateType.BrightnessState.newBuilder().setBrightness(average.doubleValue()), (TimeUnit)TimeUnit.MICROSECONDS, (Logger)this.logger)).build();
    }
}

