/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.Dimmer;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.DimmerDataType;

public class DimmerRemote
extends AbstractUnitRemote<DimmerDataType.DimmerData>
implements Dimmer {
    public DimmerRemote() {
        super(DimmerDataType.DimmerData.class);
    }

    public Future<ActionFutureType.ActionFuture> setPowerState(PowerStateType.PowerState powerState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)powerState, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting powerState.", (Throwable)ex);
        }
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((DimmerDataType.DimmerData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setBrightnessState(BrightnessStateType.BrightnessState brightnessState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)brightnessState, ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting brightnessState.", (Throwable)ex);
        }
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        try {
            return ((DimmerDataType.DimmerData)this.getData()).getBrightnessState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("BrightnessState", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)DimmerDataType.DimmerData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
    }
}

