/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit.user;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.unit.user.User;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.UserActivityStateType;
import rst.domotic.state.UserPresenceStateType;
import rst.domotic.unit.user.UserConfigType;
import rst.domotic.unit.user.UserDataType;

public class UserRemote
extends AbstractUnitRemote<UserDataType.UserData>
implements User {
    public UserRemote() {
        super(UserDataType.UserData.class);
    }

    public UserActivityStateType.UserActivityState getUserActivityState() throws NotAvailableException {
        try {
            return ((UserDataType.UserData)this.getData()).getUserActivityState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("user activity", (Throwable)ex);
        }
    }

    public UserPresenceStateType.UserPresenceState getUserPresenceState() throws NotAvailableException {
        try {
            return ((UserDataType.UserData)this.getData()).getUserPresenceState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("user presence state", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setUserActivityState(UserActivityStateType.UserActivityState userActivityState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)userActivityState, ServiceTemplateType.ServiceTemplate.ServiceType.USER_ACTIVITY_STATE_SERVICE).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting activationState.", (Throwable)ex);
        }
    }

    public Future<ActionFutureType.ActionFuture> setUserPresenceState(UserPresenceStateType.UserPresenceState userPresenceState) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescription = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)ActionAuthorityType.ActionAuthority.getDefaultInstance(), (ResourceAllocationType.ResourceAllocation.Initiator)ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
        try {
            return this.applyAction(this.updateActionDescription(actionDescription, (Message)userPresenceState, ServiceTemplateType.ServiceTemplate.ServiceType.USER_PRESENCE_STATE_SERVICE).build());
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Interrupted while setting activationState.", (Throwable)ex);
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UserDataType.UserData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UserConfigType.UserConfig.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
    }
}

