/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.action;

import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.action.Action;
import org.openbase.bco.dal.remote.service.AbstractServiceRemote;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactory;
import org.openbase.bco.dal.remote.service.ServiceRemoteFactoryImpl;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.rsb.ScopeType;
import rst.timing.IntervalType;

public class RemoteAction
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAction.class);
    private ActionDescriptionType.ActionDescription actionDescription;
    private UnitConfigType.UnitConfig unitConfig;
    private ServiceRemoteFactory serviceRemoteFactory;
    private AbstractServiceRemote<?, ?> serviceRemote;
    private Future<ActionFutureType.ActionFuture> executionFuture;
    private final SyncObject executionSync = new SyncObject(RemoteAction.class);

    public void init(ActionDescriptionType.ActionDescription actionDescription) throws InitializationException, InterruptedException {
        this.actionDescription = actionDescription;
        try {
            if (actionDescription.getServiceStateDescription().getUnitId().isEmpty()) {
                throw new InvalidStateException(actionDescription.getLabel() + " has no valid unit id!");
            }
            this.serviceRemoteFactory = ServiceRemoteFactoryImpl.getInstance();
            Registries.getUnitRegistry().waitForData();
            this.unitConfig = Registries.getUnitRegistry().getUnitConfigById(actionDescription.getServiceStateDescription().getUnitId());
            this.verifyUnitConfig(this.unitConfig);
            this.serviceRemote = (AbstractServiceRemote)this.serviceRemoteFactory.newInstance(actionDescription.getServiceStateDescription().getServiceType());
            this.serviceRemote.setInfrastructureFilter(false);
            this.serviceRemote.init(this.unitConfig);
            this.serviceRemote.activate();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    private void verifyUnitConfig(UnitConfigType.UnitConfig unitConfig) throws VerificationFailedException {
        if (!unitConfig.getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED)) {
            try {
                throw new VerificationFailedException("Referred Unit[" + ScopeGenerator.generateStringRep((ScopeType.Scope)unitConfig.getScope()) + "] is disabled!");
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
                throw new VerificationFailedException("Referred Unit[" + unitConfig.getLabel() + "] is disabled!");
            }
        }
    }

    public Future<ActionFutureType.ActionFuture> execute() throws CouldNotPerformException {
        SyncObject syncObject = this.executionSync;
        synchronized (syncObject) {
            try {
                ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = ResourceAllocationType.ResourceAllocation.newBuilder();
                resourceAllocation.setPolicy(ResourceAllocationType.ResourceAllocation.Policy.FIRST);
                resourceAllocation.setInitiator(ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM);
                resourceAllocation.setPriority(ResourceAllocationType.ResourceAllocation.Priority.NORMAL);
                resourceAllocation.setId(UUID.randomUUID().toString());
                resourceAllocation.setState(ResourceAllocationType.ResourceAllocation.State.REQUESTED);
                resourceAllocation.setSlot(IntervalType.Interval.getDefaultInstance());
                this.actionDescription = this.actionDescription.toBuilder().setResourceAllocation(resourceAllocation).build();
                return this.serviceRemote.applyAction(this.getActionDescription());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new CouldNotPerformException("Could not execute remote action[" + this + "] because of interruption");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinalization() throws CouldNotPerformException, InterruptedException {
        Future<ActionFutureType.ActionFuture> currentExecution;
        SyncObject syncObject = this.executionSync;
        synchronized (syncObject) {
            if (this.executionFuture == null) {
                throw new InvalidStateException("No execution running!");
            }
            currentExecution = this.executionFuture;
        }
        try {
            currentExecution.get();
        }
        catch (ExecutionException ex) {
            throw new CouldNotPerformException("Could not wait for execution!", (Throwable)ex);
        }
    }

    public ActionDescriptionType.ActionDescription getActionDescription() throws NotAvailableException {
        return this.actionDescription;
    }

    public String toString() {
        if (this.actionDescription == null) {
            return this.getClass().getSimpleName() + "[?]";
        }
        return this.getClass().getSimpleName() + "[" + this.actionDescription.getServiceStateDescription().getUnitId() + "|" + this.actionDescription.getServiceStateDescription().getServiceType() + "|" + this.actionDescription.getServiceStateDescription().getServiceAttribute() + "|" + this.actionDescription.getServiceStateDescription().getUnitId() + "]";
    }
}

