/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.AuthenticationClientHandler;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.authentication.lib.future.AuthenticatedActionFuture;
import org.openbase.bco.dal.lib.layer.service.ServiceDataFilteredObservable;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.lib.layer.unit.UnitDataFilteredObservable;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.future.UnitSynchronisationFuture;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.MessageObservable;
import org.openbase.jul.extension.protobuf.processing.GenericMessageProcessor;
import org.openbase.jul.extension.protobuf.processing.MessageProcessor;
import org.openbase.jul.extension.rsb.com.AbstractConfigurableRemote;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.extension.rst.iface.ScopeProvider;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.FutureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rsb.Scope;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.SnapshotType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.registry.UnitRegistryDataType;
import rst.domotic.service.ServiceDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.service.ServiceTempusTypeType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public abstract class AbstractUnitRemote<D extends GeneratedMessage>
extends AbstractConfigurableRemote<D, UnitConfigType.UnitConfig>
implements UnitRemote<D> {
    private UnitTemplateType.UnitTemplate template;
    private boolean initialized = false;
    private final Observer<UnitRegistryDataType.UnitRegistryData> unitRegistryObserver = new Observer<UnitRegistryDataType.UnitRegistryData>(){

        public void update(Observable<UnitRegistryDataType.UnitRegistryData> source, UnitRegistryDataType.UnitRegistryData data) throws Exception {
            try {
                UnitConfigType.UnitConfig newUnitConfig = Registries.getUnitRegistry((boolean)true).getUnitConfigById(AbstractUnitRemote.this.getId());
                if (!newUnitConfig.equals((Object)AbstractUnitRemote.this.getConfig())) {
                    AbstractUnitRemote.this.applyConfigUpdate(newUnitConfig);
                }
            }
            catch (NotAvailableException ex) {
                AbstractUnitRemote.this.logger.debug("Could not update unit remote", (Throwable)ex);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)("Could not update unit config of " + this), (Throwable)ex, (Logger)AbstractUnitRemote.this.logger);
            }
        }
    };
    private final Map<ServiceTempusTypeType.ServiceTempusType.ServiceTempus, UnitDataFilteredObservable<D>> unitDataObservableMap = new HashMap<ServiceTempusTypeType.ServiceTempusType.ServiceTempus, UnitDataFilteredObservable<D>>();
    private final Map<ServiceTempusTypeType.ServiceTempusType.ServiceTempus, Map<ServiceTemplateType.ServiceTemplate.ServiceType, MessageObservable>> serviceTempusServiceTypeObservableMap = new HashMap<ServiceTempusTypeType.ServiceTempusType.ServiceTempus, Map<ServiceTemplateType.ServiceTemplate.ServiceType, MessageObservable>>();
    private SessionManager sessionManager;

    public AbstractUnitRemote(Class<D> dataClass) {
        super(dataClass, UnitConfigType.UnitConfig.class);
        for (ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus : ServiceTempusTypeType.ServiceTempusType.ServiceTempus.values()) {
            this.unitDataObservableMap.put(serviceTempus, new UnitDataFilteredObservable((DataProvider)this, serviceTempus));
            super.addDataObserver((source, data1) -> this.unitDataObservableMap.get(serviceTempus).notifyObservers(data1));
            this.serviceTempusServiceTypeObservableMap.put(serviceTempus, new HashMap());
            this.addDataObserver(serviceTempus, (source, data1) -> {
                HashSet<ServiceTemplateType.ServiceTemplate.ServiceType> serviceTypeSet = new HashSet<ServiceTemplateType.ServiceTemplate.ServiceType>();
                for (ServiceDescriptionType.ServiceDescription serviceDescription : this.getUnitTemplate().getServiceDescriptionList()) {
                    if (serviceDescription.getPattern() == ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER && serviceTempus == ServiceTempusTypeType.ServiceTempusType.ServiceTempus.REQUESTED || serviceTypeSet.contains(serviceDescription.getType())) continue;
                    serviceTypeSet.add(serviceDescription.getType());
                    try {
                        Object serviceData = Services.invokeServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)serviceDescription.getType(), (ServiceTemplateType.ServiceTemplate.ServicePattern)ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER, (ServiceTempusTypeType.ServiceTempusType.ServiceTempus)serviceTempus, (Object)data1, (Object[])new Object[0]);
                        this.serviceTempusServiceTypeObservableMap.get(serviceTempus).get(serviceDescription.getType()).notifyObservers(serviceData);
                    }
                    catch (CouldNotPerformException ex) {
                        this.logger.debug("Could not notify state update for service[" + serviceDescription.getType() + "] because this service is not supported by this remote controller.", (Throwable)ex);
                    }
                }
            });
        }
    }

    protected UnitRegistry getUnitRegistry() throws InterruptedException, CouldNotPerformException {
        Registries.getUnitRegistry().waitForData();
        return Registries.getUnitRegistry();
    }

    public void initById(String id) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getUnitRegistry().getUnitConfigById(id));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void initByLabel(String label) throws InitializationException, InterruptedException {
        try {
            List unitConfigList = this.getUnitRegistry().getUnitConfigsByLabel(label);
            if (unitConfigList.isEmpty()) {
                throw new NotAvailableException("Unit with Label[" + label + "]");
            }
            if (unitConfigList.size() > 1) {
                throw new InvalidStateException("Unit with Label[" + label + "] is not unique!");
            }
            this.init((GeneratedMessage)unitConfigList.get(0));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(ScopeType.Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init((GeneratedMessage)this.getUnitRegistry().getUnitConfigByScope(scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(Scope scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeTransformer.transform((Scope)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String scope) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)scope));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Deprecated
    public void init(String label, ScopeProvider location) throws InitializationException, InterruptedException {
        try {
            this.init(ScopeGenerator.generateScope((String)label, (String)this.getDataClass().getSimpleName(), (ScopeType.Scope)location.getScope()));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            this.setMessageProcessor((MessageProcessor)new GenericMessageProcessor(this.getDataClass()));
            if (!this.initialized) {
                Registries.getUnitRegistry().addDataObserver(this.unitRegistryObserver);
                this.initialized = true;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void addServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus, ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Observer observer) {
        this.serviceTempusServiceTypeObservableMap.get(serviceTempus).get(serviceType).addObserver(observer);
    }

    public void removeServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus, ServiceTemplateType.ServiceTemplate.ServiceType serviceType, Observer observer) {
        this.serviceTempusServiceTypeObservableMap.get(serviceTempus).get(serviceType).removeObserver(observer);
    }

    public void addDataObserver(Observer<D> observer) {
        this.addDataObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.CURRENT, observer);
    }

    public void addDataObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus, Observer<D> observer) {
        this.unitDataObservableMap.get(serviceTempus).addObserver(observer);
    }

    public void removeDataObserver(Observer<D> observer) {
        this.removeDataObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.CURRENT, observer);
    }

    public void removeDataObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus, Observer<D> observer) {
        this.unitDataObservableMap.get(serviceTempus).removeObserver(observer);
    }

    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        if (config == null) {
            throw new NotAvailableException("UnitConfig");
        }
        try {
            if (((UnitConfigType.UnitConfig)this.getConfig()).equals((Object)config)) {
                this.logger.debug("Skip config update because no config change detected!");
                return config;
            }
        }
        catch (NotAvailableException ex) {
            this.logger.trace("Unit config change check failed because config is not available yet.");
        }
        this.template = this.getUnitRegistry().getUnitTemplateByType(config.getType());
        for (ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus : ServiceTempusTypeType.ServiceTempusType.ServiceTempus.values()) {
            this.unitDataObservableMap.get(serviceTempus).updateToUnitTemplateChange(this.template);
            for (ServiceDescriptionType.ServiceDescription serviceDescription : this.template.getServiceDescriptionList()) {
                if (serviceDescription.getPattern() == ServiceTemplateType.ServiceTemplate.ServicePattern.PROVIDER && serviceTempus == ServiceTempusTypeType.ServiceTempusType.ServiceTempus.REQUESTED || this.serviceTempusServiceTypeObservableMap.get(serviceTempus).containsKey(serviceDescription.getType())) continue;
                this.serviceTempusServiceTypeObservableMap.get(serviceTempus).put(serviceDescription.getType(), (MessageObservable)new ServiceDataFilteredObservable((DataProvider)this));
            }
        }
        for (Map map : this.serviceTempusServiceTypeObservableMap.values()) {
            block5: for (ServiceTemplateType.ServiceTemplate.ServiceType serviceType : map.keySet()) {
                for (ServiceDescriptionType.ServiceDescription serviceDescription : this.template.getServiceDescriptionList()) {
                    if (serviceType != serviceDescription.getType()) continue;
                    continue block5;
                }
                ((MessageObservable)map.remove(serviceType)).shutdown();
            }
        }
        return (UnitConfigType.UnitConfig)super.applyConfigUpdate((GeneratedMessage)config);
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        if (!this.isEnabled()) {
            throw new InvalidStateException("The activation of an remote is not allowed if the referred unit is disabled!");
        }
        if (!Units.contains(this)) {
            this.logger.warn("You are using a unit remote which is not maintained by the global unit remote pool! This is extremely inefficient! Please use \"Units.getUnit(...)\" instead creating your own instances!");
        }
        super.activate();
    }

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        this.verifyEnablingState();
        super.waitForData();
    }

    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.verifyEnablingState();
        super.waitForData(timeout, timeUnit);
    }

    public boolean isEnabled() {
        try {
            assert (this.getConfig() instanceof UnitConfigType.UnitConfig);
            return ((UnitConfigType.UnitConfig)this.getConfig()).getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED);
        }
        catch (CouldNotPerformException ex) {
            LoggerFactory.getLogger(UnitRemote.class).warn("isEnabled() was called on non initialized unit!");
            assert (false);
            return false;
        }
    }

    private void verifyEnablingState() throws FatalImplementationErrorException {
        if (!this.isEnabled()) {
            if (JPService.testMode()) {
                throw new FatalImplementationErrorException("Waiting for data of a disabled unit should be avoided!", (Object)"Calling instance");
            }
            this.logger.warn("Waiting for data of an disabled unit should be avoided! Probably this method will block forever!");
        }
    }

    public UnitTemplateType.UnitTemplate.UnitType getUnitType() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getType();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit type", ex);
        }
    }

    public UnitTemplateType.UnitTemplate getUnitTemplate() throws NotAvailableException {
        if (this.template == null) {
            throw new NotAvailableException("UnitTemplate");
        }
        return this.template;
    }

    public String getLabel() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getLabel();
        }
        catch (NullPointerException | NotAvailableException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public ScopeType.Scope getScope() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getScope();
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("unit label", ex);
        }
    }

    public UnitConfigType.UnitConfig getParentLocationConfig() throws NotAvailableException, InterruptedException {
        try {
            return this.getUnitRegistry().getUnitConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId());
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("LocationConfig", (Throwable)ex);
        }
    }

    @Deprecated
    public UnitConfigType.UnitConfig getLocationConfig() throws NotAvailableException {
        try {
            return this.getParentLocationConfig();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new NotAvailableException((Throwable)ex);
        }
    }

    public LocationRemote getParentLocationRemote(boolean waitForData) throws NotAvailableException, InterruptedException {
        try {
            return Units.getUnit(((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), waitForData, Units.LOCATION);
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("LocationRemote", (Throwable)ex);
        }
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Deprecated
    public Future<Transform> getTransformation() throws InterruptedException {
        try {
            return Units.getRootToUnitTransformationFuture((UnitConfigType.UnitConfig)this.getConfig());
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture(Transform.class, (Exception)((Object)new NotAvailableException("UnitTransformation", (Throwable)ex)));
        }
    }

    public Future<ActionFutureType.ActionFuture> applyAction(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException, InterruptedException, RejectedException {
        ActionDescriptionType.ActionDescription initializedActionDescription = this.initializeRequest(actionDescription);
        return new UnitSynchronisationFuture((Future<ActionFutureType.ActionFuture>)new AuthenticatedActionFuture(RPCHelper.callRemoteMethod((Object)initializedActionDescription, (RSBRemote)this, ActionFutureType.ActionFuture.class), initializedActionDescription.getActionAuthority().getTicketAuthenticatorWrapper(), this.sessionManager), this);
    }

    private ActionDescriptionType.ActionDescription initializeRequest(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = actionDescription.toBuilder();
        if (this.isLoggedIn()) {
            try {
                this.isAuthenticated();
            }
            catch (CouldNotPerformException ex) {
                try {
                    this.sessionManager.relog();
                }
                catch (CouldNotPerformException ex2) {
                    this.sessionManager.logout();
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    throw new CouldNotPerformException("Your session has expired. You have been logged out for security reasons. Please log in again.");
                }
            }
        }
        if (this.isAuthenticated()) {
            try {
                TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper = AuthenticationClientHandler.initServiceServerRequest((byte[])this.sessionManager.getSessionKey(), (TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper)this.sessionManager.getTicketAuthenticatorWrapper());
                ActionAuthorityType.ActionAuthority.Builder actionAuthorityBuilder = actionDescriptionBuilder.getActionAuthorityBuilder();
                actionAuthorityBuilder.setTicketAuthenticatorWrapper(wrapper);
            }
            catch (IOException | BadPaddingException ex) {
                throw new CouldNotPerformException("Could not initialize client server ticket for request", (Throwable)ex);
            }
        } else {
            actionDescriptionBuilder.clearActionAuthority();
        }
        return actionDescriptionBuilder.build();
    }

    private boolean isLoggedIn() {
        return this.sessionManager != null && this.sessionManager.isLoggedIn();
    }

    private boolean isAuthenticated() throws CouldNotPerformException {
        return this.sessionManager != null && this.sessionManager.isAuthenticated();
    }

    public Future<SnapshotType.Snapshot> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((RSBRemote)this, SnapshotType.Snapshot.class);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void shutdown() {
        super.shutdown();
        try {
            Registries.getUnitRegistry().removeDataObserver(this.unitRegistryObserver);
        }
        catch (NotAvailableException notAvailableException) {
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not remove unit registry observer.", (Throwable)ex), (Logger)this.logger);
        }
        for (ServiceTempusTypeType.ServiceTempusType.ServiceTempus serviceTempus : ServiceTempusTypeType.ServiceTempusType.ServiceTempus.values()) {
            for (MessageObservable serviceObservable : this.serviceTempusServiceTypeObservableMap.get(serviceTempus).values()) {
                serviceObservable.shutdown();
            }
            this.unitDataObservableMap.get(serviceTempus).shutdown();
        }
    }

    public String toString() {
        try {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[scope:" + ScopeGenerator.generateStringRep((ScopeType.Scope)this.scope) + "]";
        }
        catch (CouldNotPerformException ex) {
            try {
                return ((Object)((Object)this)).getClass().getSimpleName() + "[label:" + this.getLabel() + "]";
            }
            catch (CouldNotPerformException exx) {
                return super.toString();
            }
        }
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionFutureType.ActionFuture.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionDescriptionType.ActionDescription.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SnapshotType.Snapshot.getDefaultInstance()));
    }
}

