/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.trigger.preset;

import com.google.protobuf.MessageOrBuilder;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.DoorStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.state.WindowStateType;
import rst.domotic.unit.location.LocationDataType;

public class NeighborConnectionPresenceTrigger
extends AbstractTrigger {
    private final Observer dataObserver;
    private final Observer<Remote.ConnectionState> connectionObserver;
    private final LocationRemote locationRemote;
    private final ConnectionRemote connectionRemote;
    private boolean active = false;

    public NeighborConnectionPresenceTrigger(LocationRemote locationRemote, ConnectionRemote connectionRemote) throws InstantiationException {
        this.locationRemote = locationRemote;
        this.connectionRemote = connectionRemote;
        this.dataObserver = (source, data) -> this.verifyCondition();
        this.connectionObserver = (source, data) -> {
            if (data.equals((Object)Remote.ConnectionState.CONNECTED)) {
                this.verifyCondition();
            } else {
                this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
            }
        };
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.addDataObserver(this.dataObserver);
        this.connectionRemote.addDataObserver(this.dataObserver);
        this.locationRemote.addConnectionStateObserver(this.connectionObserver);
        this.connectionRemote.addConnectionStateObserver(this.connectionObserver);
        this.active = true;
        this.verifyCondition();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.removeDataObserver(this.dataObserver);
        this.connectionRemote.removeDataObserver(this.dataObserver);
        this.locationRemote.removeConnectionStateObserver(this.connectionObserver);
        this.connectionRemote.removeConnectionStateObserver(this.connectionObserver);
        this.active = false;
        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
    }

    public boolean isActive() {
        return this.active;
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + (Object)((Object)this)), (Throwable)ex, (Logger)LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
        }
        super.shutdown();
    }

    private void verifyCondition() {
        try {
            if (((LocationDataType.LocationData)this.locationRemote.getData()).getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.PRESENT) && (this.connectionRemote.getDoorState().getValue().equals((Object)DoorStateType.DoorState.State.OPEN) || this.connectionRemote.getWindowState().getValue().equals((Object)WindowStateType.WindowState.State.OPEN))) {
                this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
            } else {
                this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not verify trigger state " + (Object)((Object)this)), (Throwable)ex, (Logger)LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
        }
    }
}

