/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.dal.remote.unit.unitgroup;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.lib.layer.service.ServiceRemote;
import org.openbase.bco.dal.lib.layer.unit.unitgroup.UnitGroup;
import org.openbase.bco.dal.remote.service.ServiceRemoteManager;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.provider.DataProvider;
import org.openbase.jul.schedule.FutureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.SnapshotType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.AlarmStateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.state.MotionStateType;
import rst.domotic.state.PowerConsumptionStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.state.SmokeStateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.state.TamperStateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.location.LocationDataType;
import rst.domotic.unit.unitgroup.UnitGroupDataType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class UnitGroupRemote
extends AbstractUnitRemote<UnitGroupDataType.UnitGroupData>
implements UnitGroup {
    private static final Logger LOGGER;
    private final ServiceRemoteManager<UnitGroupDataType.UnitGroupData> serviceRemoteManager = new ServiceRemoteManager<UnitGroupDataType.UnitGroupData>((DataProvider)this){

        @Override
        protected Set<ServiceTemplateType.ServiceTemplate.ServiceType> getManagedServiceTypes() throws NotAvailableException, InterruptedException {
            return UnitGroupRemote.this.getSupportedServiceTypes();
        }

        @Override
        protected void notifyServiceUpdate(Observable source, Object data) throws NotAvailableException, InterruptedException {
            UnitGroupRemote.this.updateUnitData();
        }
    };

    public UnitGroupRemote() throws InstantiationException {
        super(UnitGroupDataType.UnitGroupData.class);
    }

    private UnitGroupDataType.UnitGroupData.Builder generateBuilder() throws NotAvailableException {
        try {
            UnitGroupDataType.UnitGroupData.Builder dataBuilder = UnitGroupDataType.UnitGroupData.newBuilder();
            dataBuilder.setId(((UnitConfigType.UnitConfig)this.getConfig()).getId());
            dataBuilder.setLabel(((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
            return dataBuilder;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("UnitGroupData.Builder", (Throwable)ex);
        }
    }

    @Override
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        UnitConfigType.UnitConfig unitConfig = super.applyConfigUpdate(config);
        this.serviceRemoteManager.applyConfigUpdate((List<String>)unitConfig.getUnitGroupConfig().getMemberIdList());
        return unitConfig;
    }

    @Override
    public void activate() throws InterruptedException, CouldNotPerformException {
        this.serviceRemoteManager.activate();
        this.updateUnitData();
    }

    public boolean isActive() {
        return this.serviceRemoteManager.isActive();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.serviceRemoteManager.deactivate();
    }

    @Override
    public void waitForData(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.serviceRemoteManager.waitForData(timeout, timeUnit);
        this.updateUnitData();
    }

    @Override
    public void waitForData() throws CouldNotPerformException, InterruptedException {
        this.serviceRemoteManager.waitForData();
        this.updateUnitData();
    }

    private void updateUnitData() throws InterruptedException {
        try {
            this.applyExternalDataUpdate((GeneratedMessage)this.serviceRemoteManager.updateBuilderWithAvailableServiceStates(this.generateBuilder(), this.getDataClass(), this.getSupportedServiceTypes()).build());
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not update current status!", (Throwable)ex), (Logger)LOGGER, (LogLevel)LogLevel.WARN);
        }
    }

    @Override
    public Future<SnapshotType.Snapshot> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return this.serviceRemoteManager.recordSnapshot();
    }

    public Future<SnapshotType.Snapshot> recordSnapshot(UnitTemplateType.UnitTemplate.UnitType unitType) throws CouldNotPerformException, InterruptedException {
        return this.serviceRemoteManager.recordSnapshot(unitType);
    }

    public Future<Void> restoreSnapshot(SnapshotType.Snapshot snapshot) throws CouldNotPerformException, InterruptedException {
        return this.serviceRemoteManager.restoreSnapshot(snapshot);
    }

    @Override
    public Future<ActionFutureType.ActionFuture> applyAction(ActionDescriptionType.ActionDescription actionDescription) throws CouldNotPerformException, InterruptedException {
        return this.serviceRemoteManager.applyAction(actionDescription);
    }

    public ServiceRemote getServiceRemote(ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws NotAvailableException {
        return this.serviceRemoteManager.getServiceRemote(serviceType);
    }

    public Future<Long> ping() {
        return this.serviceRemoteManager.ping();
    }

    public Long getPing() {
        return this.serviceRemoteManager.getPing();
    }

    public CompletableFuture<UnitGroupDataType.UnitGroupData> requestData() {
        return FutureProcessor.toCompletableFuture(() -> {
            Future<UnitGroupDataType.UnitGroupData.Builder> builderFuture = this.serviceRemoteManager.requestData(this.generateBuilder());
            try {
                this.applyExternalDataUpdate((GeneratedMessage)builderFuture.get().build());
                return builderFuture.get().build();
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Could not update current status!", (Throwable)ex);
            }
        });
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)UnitGroupDataType.UnitGroupData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationDataType.LocationData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)HSBColorType.HSBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorStateType.ColorState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorType.Color.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)RGBColorType.RGBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)AlarmStateType.AlarmState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)MotionStateType.MotionState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerConsumptionStateType.PowerConsumptionState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BlindStateType.BlindState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SmokeStateType.SmokeState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)StandbyStateType.StandbyState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TamperStateType.TamperState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TemperatureStateType.TemperatureState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PresenceStateType.PresenceState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionDescriptionType.ActionDescription.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SnapshotType.Snapshot.getDefaultInstance()));
        LOGGER = LoggerFactory.getLogger(UnitGroupRemote.class);
    }
}

