/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openbase.bco.eveson.GenericListener;
import org.openbase.bco.eveson.ScopePlayer;
import org.openbase.jul.exception.CouldNotPerformException;

public class EventPlayer {
    private static EventPlayer instance;
    private final Map<String, ScopePlayer> scopeSampleMap;
    private final List<GenericListener> listenerMap;
    private static float maxAmplitude;

    public EventPlayer(Map<String, ScopePlayer> scopeSampleMap) {
        this.scopeSampleMap = scopeSampleMap;
        this.listenerMap = new ArrayList<GenericListener>();
        instance = this;
    }

    public void play() throws InterruptedException, CouldNotPerformException {
        try {
            for (Map.Entry<String, ScopePlayer> config : this.scopeSampleMap.entrySet()) {
                if (config.getValue().getType().equals((Object)ScopePlayer.Type.CUSTOM) || config.getValue().getType().equals((Object)ScopePlayer.Type.BACKGROUND)) continue;
                GenericListener listener = new GenericListener(config.getKey(), config.getValue());
                this.listenerMap.add(listener);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not play!", (Throwable)ex);
        }
    }

    public Map<String, ScopePlayer> getScopeSampleMap() {
        return this.scopeSampleMap;
    }

    public static EventPlayer getInstance() {
        return instance;
    }

    public static void setMaxAmplitude(float maxAmplitude) {
        EventPlayer.maxAmplitude = maxAmplitude;
    }

    public static float getMaxAmplitude() {
        return maxAmplitude;
    }
}

