/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitGenerator;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.openbase.bco.eveson.EventPlayer;
import org.openbase.bco.eveson.EvesonConfig;
import org.openbase.bco.eveson.PlayerConfig;
import org.openbase.bco.eveson.ScopePlayer;
import org.openbase.bco.eveson.jp.JPAudioOutputDevice;
import org.openbase.bco.eveson.jp.JPAudioResoureFolder;
import org.openbase.bco.eveson.jp.JPAudioVolume;
import org.openbase.bco.eveson.jp.JPThemeFile;
import org.openbase.bco.eveson.remotes.LocationObserver;
import org.openbase.bco.eveson.remotes.Remotes;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.processing.JSonObjectFileProcessor;

public class Eveson
implements Launchable<Void>,
VoidInitializable {
    private static Synthesizer synthesizer;
    private static LineOut lineOut;
    private EvesonConfig evesonConfig;
    private boolean active = false;

    public void init() throws InitializationException, InterruptedException {
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.active = true;
        try {
            AudioDeviceManager audioManager = AudioDeviceFactory.createAudioDeviceManager();
            synthesizer = JSyn.createSynthesizer();
            lineOut = new LineOut();
            synthesizer.add((UnitGenerator)lineOut);
            int audioDevice = this.loadAudioDevice(audioManager);
            int outputChannles = audioManager.getMaxInputChannels(audioDevice);
            if (outputChannles <= 0) {
                System.out.println("WARN: Audio channel detection failed. Try to force at least to output channels.");
                outputChannles = 2;
            }
            synthesizer.start();
            synthesizer.start(44100, -1, 0, audioDevice, outputChannles);
            lineOut.start();
            String prefix = ((File)((JPAudioResoureFolder)JPService.getProperty(JPAudioResoureFolder.class)).getValue()).getAbsolutePath();
            float amplitude = ((Float)((JPAudioVolume)JPService.getProperty(JPAudioVolume.class)).getValue()).floatValue();
            if (amplitude > 1.0f || amplitude < 0.0f) {
                System.out.println("Invalid amplitude!");
                amplitude = 1.0f;
            }
            System.out.println("Setting maximum amplitude to " + amplitude);
            EventPlayer.setMaxAmplitude(amplitude);
            HashMap<String, ScopePlayer> scopeSampleMap = new HashMap<String, ScopePlayer>();
            JSonObjectFileProcessor fileProcessor = new JSonObjectFileProcessor(EvesonConfig.class);
            this.evesonConfig = (EvesonConfig)fileProcessor.deserialize((File)((JPThemeFile)JPService.getProperty(JPThemeFile.class)).getValue());
            int timeframe = this.evesonConfig.getTimeframe() > 0 ? this.evesonConfig.getTimeframe() : 100;
            double changestep = this.evesonConfig.getChangestep() > 0.0 ? this.evesonConfig.getChangestep() : 0.05;
            double alpha = this.evesonConfig.getAlpha() > 0.0 ? this.evesonConfig.getAlpha() : 0.2;
            LocationObserver.setThresholds(this.evesonConfig.PowerConsumptionThresholdNormal, this.evesonConfig.PowerConsumptionThresholdHigh, this.evesonConfig.PowerConsumptionThresholdExtreme, timeframe, changestep, alpha);
            System.out.println("Thresholds: " + this.evesonConfig.PowerConsumptionThresholdNormal + ", " + this.evesonConfig.PowerConsumptionThresholdHigh + ", " + this.evesonConfig.PowerConsumptionThresholdExtreme);
            if (this.evesonConfig.getDefaultVoices() < 0) {
                this.evesonConfig.setDefaultVoices(5);
                System.out.println("Invalid default number for voices: setting to 5...");
            }
            System.out.println("Default voices: " + this.evesonConfig.getDefaultVoices());
            ArrayList<PlayerConfig> configList = this.evesonConfig.getPlayerConfigList();
            configList.stream().forEach(config -> {
                try {
                    int maxVoices = config.getMaxVoices();
                    float relativeAmplitude = config.getAmplitude();
                    if (maxVoices < 1) {
                        maxVoices = this.evesonConfig.defaultVoices;
                    }
                    if (relativeAmplitude <= 0.0f) {
                        relativeAmplitude = 1.0f;
                    }
                    scopeSampleMap.put(config.getId(), new ScopePlayer(prefix + "/" + config.getSampleFile(), config.getType(), maxVoices, relativeAmplitude, config.getEventFilter()));
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("error occured... skipping sample " + config.getSampleFile(), (Throwable)ex), (PrintStream)System.err);
                }
            });
            new EventPlayer(scopeSampleMap).play();
            Remotes remotes = new Remotes();
            remotes.init();
        }
        catch (JPNotAvailableException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not launch eveson!", ex);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.active = false;
    }

    private int loadAudioDevice(AudioDeviceManager audioManager) throws CouldNotPerformException {
        try {
            System.out.println("load audio device: " + (String)((JPAudioOutputDevice)JPService.getProperty(JPAudioOutputDevice.class)).getValue() + " [" + ((JPAudioOutputDevice)JPService.getProperty(JPAudioOutputDevice.class)).getAudioOutputDeviceId() + "]");
            int selectedDeviceId = ((JPAudioOutputDevice)JPService.getProperty(JPAudioOutputDevice.class)).getAudioOutputDeviceId();
            System.out.println(audioManager.getMaxInputChannels(selectedDeviceId) + " input and " + audioManager.getMaxOutputChannels(selectedDeviceId) + " output channels found.");
            return selectedDeviceId;
        }
        catch (JPServiceException ex) {
            throw new CouldNotPerformException("Could not load audio device!", (Throwable)ex);
        }
    }

    public static Synthesizer getSynthesizer() {
        return synthesizer;
    }

    public static LineOut getLineOut() {
        return lineOut;
    }

    public EvesonConfig getEvesonConfig() {
        return this.evesonConfig;
    }

    public void shutdown() {
        throw new UnsupportedOperationException("shutdown: Not supported yet.");
    }
}

