/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson.remotes;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.remote.unit.MotionDetectorRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.eveson.EventPlayer;
import org.openbase.bco.eveson.PowerTest;
import org.openbase.bco.eveson.remotes.LocationObserver;
import org.openbase.bco.eveson.remotes.MotionSensorObserver;
import org.openbase.bco.registry.location.lib.LocationRegistry;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.JPShowGUI;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.pattern.Observer;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class Remotes {
    UnitRegistry unitRegistry;
    LocationRegistry locationRegistry;

    public Remotes() throws InstantiationException, InterruptedException {
        try {
            CachedUnitRegistryRemote.waitForData();
            CachedLocationRegistryRemote.waitForData();
            this.unitRegistry = CachedUnitRegistryRemote.getRegistry();
            this.locationRegistry = CachedLocationRegistryRemote.getRegistry();
        }
        catch (CouldNotPerformException ex) {
            Logger.getLogger(Remotes.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws InterruptedException {
        try {
            LocationRemote locationRemote = new LocationRemote();
            locationRemote.init((GeneratedMessage)this.locationRegistry.getRootLocationConfig());
            locationRemote.activate();
            LocationObserver locationObserver = new LocationObserver();
            locationRemote.addDataObserver((Observer)locationObserver);
            if (((Boolean)((JPShowGUI)JPService.getProperty(JPShowGUI.class)).getValue()).booleanValue()) {
                new PowerTest(locationObserver).setVisible(true);
            }
            List motionDetectors = this.unitRegistry.getUnitConfigs(UnitTemplateType.UnitTemplate.UnitType.MOTION_DETECTOR);
            ArrayList<MotionDetectorRemote> motionDetectorRemotes = new ArrayList<MotionDetectorRemote>();
            int i = 1;
            for (UnitConfigType.UnitConfig motionDetectorConfig : motionDetectors) {
                if (motionDetectorConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) continue;
                MotionDetectorRemote remote = new MotionDetectorRemote();
                remote.init((GeneratedMessage)motionDetectorConfig);
                remote.activate();
                motionDetectorRemotes.add(remote);
                String id = motionDetectorConfig.getType().name() + "_" + i;
                if (EventPlayer.getInstance().getScopeSampleMap().containsKey(id)) {
                    remote.addDataObserver((Observer)new MotionSensorObserver(id));
                }
                ++i;
            }
        }
        catch (InitializationException | InstantiationException ex) {
            Logger.getLogger(Remotes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (CouldNotPerformException ex) {
            Logger.getLogger(Remotes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JPNotAvailableException ex) {
            Logger.getLogger(Remotes.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.unitRegistry.shutdown();
        }
    }
}

