/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson.remotes;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.openbase.bco.eveson.EventPlayer;
import org.openbase.bco.eveson.ScopePlayer;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import rst.domotic.unit.location.LocationDataType;

public class LocationObserver
implements Observer<LocationDataType.LocationData> {
    private static double THRESHOLD_NORMAL;
    private static double THRESHOLD_HIGH;
    private static double THRESHOLD_EXTREME;
    private ScopePlayer sp_normal;
    private ScopePlayer sp_high;
    private ScopePlayer sp_extreme;
    private static double ALPHA;
    private double lastValue = 0.0;
    private static int TIMEFRAME;
    private static double CHANGESTEP;
    Timer time = new Timer();
    private double consumption;
    private double lastSpNormalConsumption = 0.0;
    private double lastSpHighConsumption = 0.0;

    public LocationObserver() throws InstantiationException {
        Map<String, ScopePlayer> scopeSampleMap = EventPlayer.getInstance().getScopeSampleMap();
        ScopePlayer normal = scopeSampleMap.get("POWER_NORMAL");
        ScopePlayer high = scopeSampleMap.get("POWER_HIGH");
        ScopePlayer extreme = scopeSampleMap.get("POWER_EXTREME");
        this.sp_normal = new ScopePlayer(normal.getSampleFile(), ScopePlayer.Type.BACKGROUND, 1, normal.getRelativeAmplitude(), null);
        this.sp_high = new ScopePlayer(high.getSampleFile(), ScopePlayer.Type.BACKGROUND, 1, high.getRelativeAmplitude(), null);
        this.sp_extreme = new ScopePlayer(extreme.getSampleFile(), ScopePlayer.Type.ADJUST, 1, extreme.getRelativeAmplitude(), null);
        this.time.schedule((TimerTask)new SmoothPowerConsumption(), 0L, (long)TIMEFRAME);
    }

    public void update(Observable<LocationDataType.LocationData> source, LocationDataType.LocationData data) throws Exception {
        this.updateConsumption(data.getPowerConsumptionState().getConsumption());
    }

    public void updateConsumption(double consumption) {
        this.consumption = consumption;
    }

    public synchronized void play(double avgConsumption) {
        double idealNormal = 0.0;
        double idealHigh = 0.0;
        if (avgConsumption < THRESHOLD_NORMAL) {
            idealNormal = avgConsumption / THRESHOLD_NORMAL;
            idealHigh = 0.0;
        } else if (avgConsumption < THRESHOLD_HIGH) {
            idealNormal = (THRESHOLD_HIGH - avgConsumption) / (THRESHOLD_HIGH - THRESHOLD_NORMAL);
            idealHigh = 1.0 - idealNormal;
        } else {
            idealNormal = 0.0;
            idealHigh = 1.0;
            if (avgConsumption > THRESHOLD_EXTREME) {
                this.sp_extreme.play(1.0);
            }
        }
        this.lastSpNormalConsumption = this.lastSpNormalConsumption > idealNormal + CHANGESTEP ? Math.max(0.0, this.lastSpNormalConsumption - CHANGESTEP) : (this.lastSpNormalConsumption < idealNormal - CHANGESTEP ? Math.min(1.0, this.lastSpNormalConsumption + CHANGESTEP) : idealNormal);
        this.sp_normal.play(this.lastSpNormalConsumption);
        this.lastSpHighConsumption = this.lastSpHighConsumption > idealHigh + CHANGESTEP ? Math.max(0.0, this.lastSpHighConsumption - CHANGESTEP) : (this.lastSpHighConsumption < idealHigh - CHANGESTEP ? Math.min(1.0, this.lastSpHighConsumption + CHANGESTEP) : idealHigh);
        this.sp_high.play(this.lastSpHighConsumption);
        System.out.println("Avg con: " + avgConsumption + " (ideal: " + this.consumption + "), normal: " + this.lastSpNormalConsumption + " (" + idealNormal + "), high: " + this.lastSpHighConsumption + "(" + idealHigh + ")");
        System.out.println(CHANGESTEP + " " + TIMEFRAME + " " + ALPHA);
    }

    private double expAverage(double value) {
        double newValue;
        this.lastValue = newValue = this.lastValue + ALPHA * (value - this.lastValue);
        return newValue;
    }

    public static void setThresholds(double normal, double high, double extreme, int time, double step, double smoothingFactor) {
        THRESHOLD_NORMAL = normal;
        THRESHOLD_HIGH = high;
        THRESHOLD_EXTREME = extreme;
        ALPHA = smoothingFactor;
        CHANGESTEP = step;
        TIMEFRAME = time;
    }

    public double getLastValue() {
        return this.lastValue;
    }

    static {
        ALPHA = 0.2;
        TIMEFRAME = 100;
        CHANGESTEP = 0.05;
    }

    public class SmoothPowerConsumption
    extends TimerTask {
        @Override
        public void run() {
            LocationObserver.this.lastValue = LocationObserver.this.expAverage(LocationObserver.this.consumption);
            LocationObserver.this.play(LocationObserver.this.lastValue);
        }
    }
}

