/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.eveson.RSBGenericConverterConfig;
import org.openbase.bco.eveson.ScopePlayer;
import org.openbase.bco.eveson.eventfilter.EventFilter;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import rsb.Factory;
import rsb.Listener;
import rsb.RSBException;

public class GenericListener {
    private ScopePlayer player;
    private String scope;
    private Listener listener;
    private EventFilter eventFilter;

    public GenericListener(String scope, ScopePlayer player) throws InstantiationException, InterruptedException {
        try {
            this.scope = scope;
            this.player = player;
            String filterType = player.getEventFilter();
            if (filterType != null) {
                Class<?> filterClass = Class.forName(EventFilter.class.getPackage().getName() + "." + filterType);
                this.eventFilter = (EventFilter)filterClass.newInstance();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GenericListener.this.shutdown();
                }
            });
            this.listener = this.eventFilter != null ? Factory.getInstance().createListener(scope) : Factory.getInstance().createListener(scope, RSBGenericConverterConfig.generateConfig());
            this.listener.addHandler(event -> {
                if (this.eventFilter != null && this.eventFilter.isCompatible(event.getData()) && this.eventFilter.filter(event.getData())) {
                    return;
                }
                player.play(0.5);
            }, true);
            this.listener.activate();
            System.out.println("Listener activated for " + this);
        }
        catch (RSBException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GenericListener.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (java.lang.InstantiationException ex) {
            Logger.getLogger(GenericListener.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GenericListener.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void shutdown() {
        if (this.listener == null) {
            return;
        }
        try {
            this.listener.deactivate();
        }
        catch (InterruptedException | RSBException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not shutdown " + this), (PrintStream)System.out);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.scope + "]";
    }
}

