/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson.jp;

import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import java.util.List;
import org.openbase.jps.exception.JPBadArgumentException;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.AbstractJPString;

public class JPAudioOutputDevice
extends AbstractJPString {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"-o", "--audio-output-device"};
    private int audioOutputDeviceId;

    public JPAudioOutputDevice() {
        super(COMMAND_IDENTIFIERS);
    }

    protected String getPropertyDefaultValue() throws JPNotAvailableException {
        AudioDeviceManager audioManager = AudioDeviceFactory.createAudioDeviceManager();
        this.audioOutputDeviceId = audioManager.getDefaultOutputDeviceID();
        return audioManager.getDeviceName(this.audioOutputDeviceId);
    }

    protected String parse(List<String> arguments) throws JPBadArgumentException {
        this.checkArgumentCount(1);
        String selectedDevice = arguments.get(0).toLowerCase();
        int selectedDeviceId = -1;
        AudioDeviceManager audioManager = AudioDeviceFactory.createAudioDeviceManager();
        for (int i = 0; i < audioManager.getDeviceCount(); ++i) {
            if (!audioManager.getDeviceName(i).toLowerCase().contains(selectedDevice)) continue;
            selectedDeviceId = i;
            System.out.println("found audio device: " + audioManager.getDeviceName(i) + "[" + audioManager.getMaxInputChannels(selectedDeviceId) + ":in|" + audioManager.getMaxOutputChannels(selectedDeviceId) + ":out]");
        }
        if (selectedDeviceId == -1) {
            throw new JPBadArgumentException("The specified AudioDevice[" + arguments.get(0) + "] could not be found!");
        }
        this.audioOutputDeviceId = selectedDeviceId;
        return audioManager.getDeviceName(selectedDeviceId);
    }

    public int getAudioOutputDeviceId() {
        return this.audioOutputDeviceId;
    }

    public String getDescription() {
        return "This property configure the audio output device.";
    }
}

