/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson;

import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.data.SequentialData;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.util.SampleLoader;
import com.softsynth.shared.time.TimeStamp;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.openbase.bco.eveson.Eveson;
import org.openbase.jul.exception.InstantiationException;

public class SampleVoice
implements UnitVoice {
    private final VariableRateDataReader samplePlayer;
    private FloatSample sample;
    Random randomGenerator = new Random();
    private int NumSamplesInDir;
    private String sampleFile;

    public SampleVoice(String sampleFile) throws InstantiationException {
        this.sampleFile = sampleFile;
        System.err.println("Create SampleVoice for random sample in folder:" + sampleFile);
        Synthesizer s = Eveson.getSynthesizer();
        LineOut l = Eveson.getLineOut();
        this.samplePlayer = new VariableRateMonoReader();
        s.add((UnitGenerator)this.samplePlayer);
        this.samplePlayer.output.connect(0, l.input, 0);
    }

    public void noteOn(double d, double a, TimeStamp ts) {
        System.out.println("sampleVoice: note On" + new Date(System.currentTimeMillis()));
        if (this.samplePlayer.dataQueue.hasMore()) {
            System.out.println("SampleVoice: No voice available, aborting");
            return;
        }
        File[] files = new File(this.sampleFile).listFiles();
        this.NumSamplesInDir = files.length;
        String randomSample = null;
        this.samplePlayer.dataQueue.clear();
        try {
            int randomInt = this.randomGenerator.nextInt(this.NumSamplesInDir);
            randomSample = files[randomInt].toString();
            this.sample = SampleLoader.loadFloatSample((File)new File(randomSample));
        }
        catch (IOException ex) {
            System.out.println("Could not load: " + randomSample);
        }
        this.samplePlayer.rate.set(this.sample.getFrameRate());
        this.samplePlayer.dataQueue.queue((SequentialData)this.sample);
        this.samplePlayer.amplitude.set(a);
    }

    public void noteOff(TimeStamp ts) {
        this.samplePlayer.dataQueue.queueOff((SequentialData)this.sample);
    }

    public UnitGenerator getUnitGenerator() {
        return this.samplePlayer;
    }

    public void setPort(String string, double d, TimeStamp ts) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void usePreset(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UnitOutputPort getOutput() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

