/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.eveson;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SequentialData;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.VoiceAllocator;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.eveson.EventPlayer;
import org.openbase.bco.eveson.Eveson;
import org.openbase.bco.eveson.SampleVoice;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;

public class ScopePlayer {
    private final int MAX_VOICES;
    private String sampleFile;
    private Type type;
    private String eventFilter;
    private VoiceAllocator allocator;
    private VariableRateDataReader samplePlayer;
    private FloatSample sample;
    private int counter = 0;
    private int randomInt;
    private Random randomGenerator = new Random();
    private int numSamplesInDir;
    private File[] files;
    private float relativeAmplitude;

    public ScopePlayer(String sampleFile, Type type, int maxVoices, float relativeAmplitude, String eventFilter) throws InstantiationException {
        this.MAX_VOICES = maxVoices;
        this.relativeAmplitude = relativeAmplitude;
        this.eventFilter = eventFilter;
        try {
            System.out.println("Load: " + sampleFile);
            this.sampleFile = sampleFile;
            this.type = type;
            switch (type) {
                case PLAY: {
                    UnitVoice[] voices = new UnitVoice[this.MAX_VOICES];
                    for (int i = 0; i < this.MAX_VOICES; ++i) {
                        SampleVoice voice = new SampleVoice(sampleFile);
                        voices[i] = voice;
                    }
                    this.allocator = new VoiceAllocator(voices);
                    break;
                }
                case ADJUST: 
                case BACKGROUND: {
                    try {
                        System.err.println("Adjust/Background: Create SampleVoice for random sample in folder:" + sampleFile);
                        this.files = new File(sampleFile).listFiles();
                        this.numSamplesInDir = this.files.length;
                        this.randomInt = this.randomGenerator.nextInt(this.numSamplesInDir);
                        sampleFile = this.files[this.randomInt].toString();
                        System.out.println("sample: " + sampleFile);
                        this.sample = SampleLoader.loadFloatSample((File)new File(sampleFile));
                    }
                    catch (IOException ex) {
                        throw new CouldNotPerformException("Could not load: " + sampleFile, (Throwable)ex);
                    }
                    this.samplePlayer = new VariableRateMonoReader();
                    this.samplePlayer.output.connect(0, Eveson.getLineOut().input, 0);
                    this.samplePlayer.output.connect(0, Eveson.getLineOut().input, 1);
                    Eveson.getSynthesizer().add((UnitGenerator)this.samplePlayer);
                    this.samplePlayer.rate.set(this.sample.getFrameRate());
                }
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void play(double amplitude) {
        if (amplitude < 0.0 || amplitude > 1.0) {
            amplitude = 1.0;
        }
        amplitude *= (double)(EventPlayer.getMaxAmplitude() * this.relativeAmplitude);
        switch (this.type) {
            case ADJUST: {
                this.samplePlayer.amplitude.set(amplitude);
                if (this.samplePlayer.dataQueue.hasMore()) break;
                this.randomInt = this.randomGenerator.nextInt(this.numSamplesInDir);
                this.sampleFile = this.files[this.randomInt].toString();
                try {
                    this.sample = SampleLoader.loadFloatSample((File)new File(this.sampleFile));
                }
                catch (IOException ex) {
                    Logger.getLogger(ScopePlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.samplePlayer.dataQueue.queue((SequentialData)this.sample);
                break;
            }
            case PLAY: {
                this.allocator.noteOn(this.counter, 1.0, amplitude, Eveson.getSynthesizer().createTimeStamp());
                ++this.counter;
                break;
            }
            case BACKGROUND: {
                this.samplePlayer.amplitude.set(amplitude);
                this.samplePlayer.dataQueue.queueLoop((SequentialData)this.sample, 0, this.sample.getNumFrames());
            }
        }
    }

    public String getSampleFile() {
        return this.sampleFile;
    }

    public Type getType() {
        return this.type;
    }

    public int getMAX_VOICES() {
        return this.MAX_VOICES;
    }

    public float getRelativeAmplitude() {
        return this.relativeAmplitude;
    }

    public String getEventFilter() {
        return this.eventFilter;
    }

    public static enum Type {
        PLAY,
        ADJUST,
        CUSTOM,
        BACKGROUND;

    }
}

