/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core;

import java.util.concurrent.TimeUnit;
import org.openbase.bco.manager.agent.core.AgentFactoryImpl;
import org.openbase.bco.manager.agent.lib.AgentController;
import org.openbase.bco.manager.agent.lib.AgentFactory;
import org.openbase.bco.manager.agent.lib.AgentManager;
import org.openbase.bco.registry.agent.remote.AgentRegistryRemote;
import org.openbase.bco.registry.device.lib.DeviceRegistry;
import org.openbase.bco.registry.device.lib.provider.DeviceRegistryProvider;
import org.openbase.bco.registry.device.remote.DeviceRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.ControllerRegistry;
import org.openbase.jul.storage.registry.EnableableEntryRegistrySynchronizer;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;

public class AgentManagerController
implements DeviceRegistryProvider,
AgentManager {
    protected static final Logger logger = LoggerFactory.getLogger(AgentManagerController.class);
    private static AgentManagerController instance;
    private final AgentFactory factory;
    private final ControllerRegistry<String, AgentController> agentRegistry;
    private final AgentRegistryRemote agentRegistryRemote;
    private final EnableableEntryRegistrySynchronizer<String, AgentController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> registrySynchronizer;
    private final DeviceRegistryRemote deviceRegistryRemote;

    public AgentManagerController() throws InstantiationException, InterruptedException {
        try {
            instance = this;
            this.factory = AgentFactoryImpl.getInstance();
            this.agentRegistry = new ControllerRegistry();
            this.deviceRegistryRemote = new DeviceRegistryRemote();
            this.agentRegistryRemote = new AgentRegistryRemote();
            this.registrySynchronizer = new EnableableEntryRegistrySynchronizer<String, AgentController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>(this.agentRegistry, (RemoteRegistry)this.agentRegistryRemote.getAgentConfigRemoteRegistry(), (Factory)this.factory){

                public boolean enablingCondition(UnitConfigType.UnitConfig config) {
                    return config.getEnablingState().getValue() == EnablingStateType.EnablingState.State.ENABLED;
                }
            };
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public static AgentManagerController getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException(AgentManagerController.class);
        }
        return instance;
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.agentRegistryRemote.init();
            this.agentRegistryRemote.activate();
            this.deviceRegistryRemote.init();
            this.deviceRegistryRemote.activate();
            this.registrySynchronizer.init();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void shutdown() {
        this.agentRegistryRemote.shutdown();
        this.deviceRegistryRemote.shutdown();
        this.deviceRegistryRemote.shutdown();
        instance = null;
    }

    public DeviceRegistry getDeviceRegistry() throws NotAvailableException {
        return this.deviceRegistryRemote;
    }

    public void waitForInit(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        this.agentRegistryRemote.waitForData(timeout, timeUnit);
        this.deviceRegistryRemote.waitForData(timeout, timeUnit);
    }
}

