/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core;

import org.openbase.bco.manager.agent.core.AgentManagerController;
import org.openbase.bco.manager.agent.lib.AgentManager;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Launcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentManagerLauncher
implements Launcher {
    protected static final Logger logger = LoggerFactory.getLogger(AgentManagerLauncher.class);
    private final AgentManagerController agentManagerController;

    public AgentManagerLauncher() throws InstantiationException, InterruptedException {
        try {
            this.agentManagerController = new AgentManagerController();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void launch() throws InstantiationException, InterruptedException {
        try {
            this.agentManagerController.init();
        }
        catch (CouldNotPerformException ex) {
            this.agentManagerController.shutdown();
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void shutdown() {
        this.agentManagerController.shutdown();
    }

    public AgentManager getAgentManager() {
        return this.agentManagerController;
    }

    public static void main(String[] args) throws InterruptedException, CouldNotPerformException {
        JPService.setApplicationName(AgentManager.class);
        JPService.parseAndExitOnError((String[])args);
        logger.info("Start " + JPService.getApplicationName() + "...");
        try {
            new AgentManagerLauncher().launch();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistoryAndExit((String)(JPService.getApplicationName() + " crashed during startup phase!"), (Throwable)ex, (Logger)logger);
            return;
        }
        logger.info(JPService.getApplicationName() + " successfully started.");
    }
}

