/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import org.openbase.bco.dal.lib.detector.PresenseDetector;
import org.openbase.bco.manager.agent.core.AbstractAgent;
import org.openbase.bco.manager.location.remote.LocationRemote;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import rst.domotic.state.MotionStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;

public class PersonLightProviderAgent
extends AbstractAgent {
    public static final double MINIMUM_LIGHT_THRESHOLD = 100.0;
    private LocationRemote locationRemote;
    private PresenseDetector presenseDetector;

    public PersonLightProviderAgent() throws InstantiationException, CouldNotPerformException, InterruptedException {
        super(false);
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote = new LocationRemote();
        CachedLocationRegistryRemote.waitForData();
        this.locationRemote.init((GeneratedMessage)CachedLocationRegistryRemote.getRegistry().getLocationConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getId()));
        this.locationRemote.activate();
        this.presenseDetector = new PresenseDetector();
        this.presenseDetector.addObserver((source, data) -> {
            try {
                this.notifyMotionStateChanged((MotionStateType.MotionStateOrBuilder)data);
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify motion state change!", (Throwable)ex), (Logger)this.logger);
            }
        });
        super.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        this.locationRemote.deactivate();
        this.presenseDetector.shutdown();
        super.deactivate();
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.deactivate();
    }

    private void notifyMotionStateChanged(MotionStateType.MotionStateOrBuilder motionState) throws CouldNotPerformException {
        if (motionState.getValue() == MotionStateType.MotionState.State.MOTION) {
            this.locationRemote.setPowerState(PowerStateType.PowerState.State.ON);
        } else {
            this.locationRemote.setPowerState(PowerStateType.PowerState.State.OFF);
        }
        this.logger.info("detect: " + motionState.getValue());
    }
}

